/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanPermissionException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultInstalledTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultRepoTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.UninstallStep;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMemberWritePermission;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.logger.Logger;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

public class PlanAutoGenerator
implements PlanExecutorMessages {
    public static final String LOGGER_AUTOGEN = "executor.autogen";

    public ExecutionPlanID installComponent(ComponentID inComponentID, String inProcedureName) throws PlanExecutionException {
        this.validateArguments(inComponentID, inProcedureName, NamedBlockType.INSTALL);
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating autogen plan for installing: " + inComponentID + "|" + inProcedureName, LOGGER_AUTOGEN);
        }
        try {
            return this.generateSimplePlan(inComponentID, inProcedureName, NamedBlockType.INSTALL).getID();
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public ExecutionPlanID uninstallComponent(ComponentID inComponentID, String inProcedureName, String[] inProcedureTargets) throws PlanExecutionException {
        this.validateArguments(inComponentID, inProcedureName, NamedBlockType.UNINSTALL, inProcedureTargets);
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating autogen plan for uninstalling: " + inComponentID + "|" + inProcedureName + " on " + Arrays.asList(inProcedureTargets), LOGGER_AUTOGEN);
        }
        try {
            return this.generatePlanWithTargets(inComponentID, NamedBlockType.UNINSTALL, inProcedureName, inProcedureTargets).getID();
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public ExecutionPlanID callComponent(ComponentID inComponentID, String inProcedureName, String[] inProcedureTargets) throws PlanExecutionException {
        this.validateArguments(inComponentID, inProcedureName, NamedBlockType.CONTROL, inProcedureTargets);
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating autogen plan for executing call: " + inComponentID + "|" + inProcedureName + " on " + Arrays.asList(inProcedureTargets), LOGGER_AUTOGEN);
        }
        try {
            return this.generatePlanWithTargets(inComponentID, NamedBlockType.CONTROL, inProcedureName, inProcedureTargets).getID();
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public String generatePlanText(ComponentID inComponentID, String[] inProcedureNames, NamedBlockType[] inProcedureTypes) throws PlanExecutionException {
        return this.generatePlanText(inComponentID, inProcedureNames, null, inProcedureTypes);
    }

    protected String generatePlanText(ComponentID inComponentID, String[] inProcedureNames, String[] inProcedureTargets, NamedBlockType[] inProcedureTypes) throws PlanExecutionException {
        if (inProcedureNames.length == 0 || inProcedureNames.length != inProcedureTypes.length || inProcedureTargets != null && inProcedureTargets.length != inProcedureNames.length) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.AUTOGENERATION_OUTOFSYNC"), this);
            }
            throw new PlanExecutionException("pe.AUTOGENERATION_OUTOFSYNC");
        }
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating plan text for: " + inComponentID + " " + (inProcedureNames == null ? null : Arrays.asList(inProcedureNames)) + " of types " + (inProcedureTypes == null ? null : Arrays.asList(inProcedureTypes)) + " on " + (inProcedureTargets == null ? null : Arrays.asList(inProcedureTargets)), LOGGER_AUTOGEN);
        }
        StepPackage[] steps = new StepPackage[inProcedureNames.length];
        Component comp = this.getComponent(inComponentID);
        for (int index = 0; index < inProcedureNames.length; ++index) {
            if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
                Logger.debug("Generating execstep for " + inProcedureNames[index] + "|" + inProcedureTypes[index], LOGGER_AUTOGEN);
            }
            try {
                steps[index] = this.generateExecStep(comp, inProcedureNames[index], null == inProcedureTargets ? null : inProcedureTargets[index], inProcedureTypes[index]);
                if (!Logger.isDebugEnabled(LOGGER_AUTOGEN)) continue;
                Logger.debug("Generated step: " + steps[index], LOGGER_AUTOGEN);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("pe.AUTOGENERATION_BADSTEP"), iae, this);
                }
                throw new PlanExecutionException("pe.AUTOGENERATION_BADSTEP");
            }
        }
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Done generating steps", LOGGER_AUTOGEN);
        }
        try {
            if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
                Logger.debug("Searching for plan to match (not going to persist, though)", LOGGER_AUTOGEN);
            }
            PlanFinder finder = new PlanFinder(comp, inProcedureNames, inProcedureTypes, inProcedureTargets);
            ExecutionPlan thePlan = finder.getPlan(steps, false, true);
            if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
                Logger.debug("Returning the following XML:\n" + thePlan.writeToXML(), LOGGER_AUTOGEN);
            }
            return thePlan.writeToXML();
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.AUTOGENERATION_PLAN"), e, this);
            }
            throw new PlanExecutionException("pe.AUTOGENERATION_PLAN");
        }
    }

    protected ExecutionPlan generateSimplePlan(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) throws PlanExecutionException, RPCException, PersistenceManagerException {
        return this.generateSimplePlan(inComponentID, inProcedureName, inProcedureType, null);
    }

    protected ExecutionPlan generateSimplePlan(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType, String inProcedureTarget) throws PlanExecutionException, RPCException, PersistenceManagerException {
        return this.generateSimplePlan(this.getComponent(inComponentID), inProcedureName, inProcedureType, inProcedureTarget);
    }

    protected ExecutionPlan generateSimplePlan(Component inComponent, String inProcedureName, NamedBlockType inProcedureType, String inProcedureTarget) throws PlanExecutionException, RPCException, PersistenceManagerException {
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating simple plan for " + inComponent.getName() + "|" + inProcedureName + "|" + inProcedureType + "|" + inProcedureTarget, LOGGER_AUTOGEN);
        }
        FolderPermission permObj = new FolderPermission(inComponent.getPath(), "autorun");
        try {
            AccessController.checkPermission(permObj);
        }
        catch (AccessControlException e) {
            throw new PlanPermissionException(inComponent, inProcedureName);
        }
        PlanFinder finder = new PlanFinder(inComponent, inProcedureName, inProcedureType, inProcedureTarget);
        StepPackage step = this.generateExecStep(inComponent, inProcedureName, inProcedureTarget, inProcedureType);
        ExecutionPlan thePlan = finder.getPlan(new StepPackage[]{step});
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating simple plan returns:\n" + thePlan.writeToXML(), LOGGER_AUTOGEN);
        }
        return thePlan;
    }

    protected ExecutionPlan generatePlanWithTargets(ComponentID inComponentID, NamedBlockType inProcedureType, String inProcedureName, String[] inProcedureTargets) throws PlanExecutionException, RPCException, PersistenceManagerException {
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating plan with targets for " + inComponentID + "|" + inProcedureName + "|" + inProcedureType + " on\n" + Arrays.asList(inProcedureTargets), LOGGER_AUTOGEN);
        }
        StepPackage[] subplanSteps = new StepPackage[inProcedureTargets.length];
        Component comp = this.getComponent(inComponentID);
        for (int counter = 0; counter < inProcedureTargets.length; ++counter) {
            if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
                Logger.debug("Generating subplan for " + comp.getName() + "|" + inProcedureName + "|" + inProcedureType + "|" + inProcedureTargets[counter], LOGGER_AUTOGEN);
            }
            ExecutionPlan subplan = this.generateSimplePlan(comp, inProcedureName, inProcedureType, inProcedureTargets[counter]);
            ExecSubplanStep subplanStep = new ExecSubplanStep(null, subplan.getName(), subplan.getVersionNumber().getAsString(), this.convertParamsToArgs(subplan.getParams()));
            if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
                Logger.debug("Generated subplan:\n" + subplanStep, LOGGER_AUTOGEN);
            }
            subplanSteps[counter] = new StepPackage(subplanStep, subplan.getParams());
        }
        PlanFinder finder = new PlanFinder(comp, inProcedureName, inProcedureType, inProcedureTargets);
        ExecutionPlan masterPlan = finder.getPlan(subplanSteps, true, false);
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating plan with targets returning:\n" + masterPlan.writeToXML(), LOGGER_AUTOGEN);
        }
        return masterPlan;
    }

    protected VariableSettingsSource convertParamsToArgs(VariableSettingsSource inParams) {
        ArgList args = new ArgList();
        if (null != inParams) {
            String[] varNames = inParams.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                StringBuffer value = new StringBuffer();
                value.append(":[").append(varNames[i]).append("]");
                args.setVarValue(varNames[i], value.toString());
            }
        }
        return args;
    }

    protected StepPackage generateExecStep(Component inComponent, String inProcedureName, String inInstallPath, NamedBlockType inStepType) throws PlanExecutionException {
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Generating an execstep for " + inComponent.getName() + "|" + inProcedureName + "|" + inInstallPath + "|" + inStepType, LOGGER_AUTOGEN);
        }
        NamedBlock block = this.getProcedureBlock(inComponent, inProcedureName, inStepType);
        PromptParamList params = block.getParams();
        ExecStep newStep = null;
        if (inStepType.equals(NamedBlockType.INSTALL)) {
            ComponentRef compRef = new ComponentRef(inComponent.getPath(), inComponent.getName(), inComponent.getVersionNumber().getAsString());
            newStep = new InstallStep(new DefaultRepoTargeter(compRef, null), inProcedureName, this.convertParamsToArgs(params));
        } else if (inStepType.equals(NamedBlockType.UNINSTALL)) {
            newStep = new UninstallStep(new DefaultInstalledTargeter(new InstalledComponentRef(inComponent.getPath(), inComponent.getName(), inComponent.getVersionNumber().getAsString(), Comparator.EQUAL, false, inInstallPath, false), null), inProcedureName, this.convertParamsToArgs(params));
        } else if (inStepType.equals(NamedBlockType.CONTROL)) {
            newStep = new CallStep(inProcedureName, new DefaultInstalledTargeter(new InstalledComponentRef(inComponent.getPath(), inComponent.getName(), inComponent.getVersionNumber().getAsString(), Comparator.EQUAL, false, inInstallPath, false), null), this.convertParamsToArgs(params));
        }
        if (Logger.isDebugEnabled(LOGGER_AUTOGEN)) {
            Logger.debug("Returning execstep:\n" + newStep, LOGGER_AUTOGEN);
        }
        return new StepPackage(newStep, params);
    }

    protected NamedBlock getProcedureBlock(Component inComponent, String inProcedureName, NamedBlockType inStepType) throws PlanExecutionException {
        NamedBlock block = null;
        if (inStepType.equals(NamedBlockType.INSTALL)) {
            block = inComponent.resolveInstallBlock(inProcedureName, CallSpec.PUBLIC);
        } else if (inStepType.equals(NamedBlockType.UNINSTALL)) {
            block = inComponent.resolveUninstallBlock(inProcedureName, CallSpec.PUBLIC);
        } else if (inStepType.equals(NamedBlockType.CONTROL)) {
            block = inComponent.resolveControlBlock(inProcedureName, CallSpec.PUBLIC);
        }
        if (null == block) {
            String stepDescription = inStepType.toString();
            ROXMessage message = new ROXMessage("pe.AUTOGENERATION_BAD_BLOCK", new Object[]{stepDescription, inProcedureName});
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString(message), this);
            }
            throw new PlanExecutionException(message);
        }
        return block;
    }

    protected Component getComponent(ComponentID inComponentID) throws PlanExecutionException {
        try {
            return inComponentID.getByIDQuery().select();
        }
        catch (RPCException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.COMPONENT_NOT_FOUND_DB"), e, this);
            }
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB");
        }
        catch (PersistenceManagerException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.COMPONENT_NOT_FOUND_DB"), e, this);
            }
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB");
        }
    }

    private void validateArguments(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) throws PlanExecutionException {
        if (inComponentID == null) {
            throw new PlanExecutionException("pe.AUTOGENERATION_BAD_COMPONENT");
        }
        if (inProcedureName == null) {
            throw new PlanExecutionException("pe.AUTOGENERATION_BAD_PROCEDURE");
        }
    }

    private void validateArguments(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType, String[] inProcedureTargets) throws PlanExecutionException {
        this.validateArguments(inComponentID, inProcedureName, inProcedureType);
        if (inProcedureTargets == null || inProcedureTargets.length == 0) {
            throw new PlanExecutionException("pe.AUTOGENERATION_NO_PATHS");
        }
    }

    protected static final class StepPackage {
        private ExecStep mStep;
        private PromptParamList mList;

        protected StepPackage(ExecStep inStep, PromptParamList inParamList) {
            this.mStep = inStep;
            this.mList = inParamList;
        }

        public ExecStep getStep() {
            return this.mStep;
        }

        public PromptParamList getParamList() {
            return this.mList;
        }
    }

    protected static class PlanFinder {
        private Component mComponent;
        private String mProcedureName;
        private String mProcedureTarget;
        private NamedBlockType mProcedureType;

        protected PlanFinder(Component inComponent, String inProcedureName, NamedBlockType inProcedureType, String inProcedureTarget) {
            this.mComponent = inComponent;
            this.mProcedureName = inProcedureName;
            this.mProcedureType = inProcedureType;
            this.mProcedureTarget = inProcedureTarget;
        }

        protected PlanFinder(Component inComponent, String[] inProcedureNames, NamedBlockType[] inProcedureTypes, String[] inProcedureTargets) {
            this.mComponent = inComponent;
        }

        protected PlanFinder(Component inComponent, String inProcedureName, NamedBlockType inProcedureType, String[] inProcedureTargets) {
            this.mComponent = inComponent;
            this.mProcedureName = inProcedureName;
            this.mProcedureType = inProcedureType;
        }

        protected ExecutionPlan getPlan(StepPackage[] inSteps) throws RPCException, PersistenceManagerException, PlanExecutionException {
            return this.getPlan(inSteps, true, true);
        }

        protected ExecutionPlan getPlan(StepPackage[] inSteps, boolean inShouldPersist, boolean inLookForPlan) throws RPCException, PersistenceManagerException, PlanExecutionException {
            if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                Logger.debug("Plan finder is searching for a plan...", PlanAutoGenerator.LOGGER_AUTOGEN);
            }
            ExecutionPlan thePlan = null;
            boolean newAGPlanNeeded = false;
            ExecStep[] steps = new ExecStep[inSteps.length];
            PromptParamList finalParamList = new PromptParamList();
            for (int i = 0; i < inSteps.length; ++i) {
                steps[i] = inSteps[i].getStep();
                PromptParamList list = inSteps[i].getParamList();
                if (list == null) continue;
                String[] varNames = list.getVarNames();
                for (int j = 0; j < varNames.length; ++j) {
                    finalParamList.addParam(list.getParam(varNames[j]));
                }
            }
            if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                Logger.debug("Plan finder has the following steps with which to work:\n" + Arrays.asList(steps), PlanAutoGenerator.LOGGER_AUTOGEN);
            }
            if (inShouldPersist && inLookForPlan) {
                AutoGeneratedPlan agPlan;
                if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                    Logger.debug("Plan finder is looking for a plan in the db: " + this.mComponent.getID() + "|" + this.mProcedureName + "|" + this.mProcedureTarget + "|" + this.mProcedureType, PlanAutoGenerator.LOGGER_AUTOGEN);
                }
                if (null == (agPlan = AutoGeneratedPlan.getAutoGeneratedPlan(this.mComponent.getID(), this.mProcedureName, this.mProcedureTarget, this.mProcedureType))) {
                    if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                        Logger.debug("No matching plan was found, searching for a plan for the component line: " + this.mComponent.getID(), PlanAutoGenerator.LOGGER_AUTOGEN);
                    }
                    thePlan = AutoGeneratedPlan.getMostRecentPlanForComponent(this.mComponent.getID(), this.mProcedureName, this.mProcedureType);
                    newAGPlanNeeded = true;
                    if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                        Logger.debug("Search for existing plan line returned:\n" + (null == thePlan ? "null" : thePlan.writeToXML()), PlanAutoGenerator.LOGGER_AUTOGEN);
                    }
                } else {
                    if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                        Logger.debug("A matching plan was found:\n" + agPlan.getPlan().writeToXML(), PlanAutoGenerator.LOGGER_AUTOGEN);
                    }
                    return agPlan.getPlan();
                }
            }
            if (null == thePlan) {
                if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                    Logger.debug("No helpful plan exists, must create a new one...", PlanAutoGenerator.LOGGER_AUTOGEN);
                }
                thePlan = new ExecutionPlan(SystemPluginConstants.getInstance().SYSTEM_PLUGIN_ID);
                thePlan.setPath(SystemPluginConstants.getInstance().AUTOGEN_FOLDER_ID);
                thePlan.setName(this.generateAutogenPlanName(this.mComponent, this.mProcedureName, this.mProcedureType));
                newAGPlanNeeded = true;
                if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                    Logger.debug("New plan is:\n" + thePlan.writeToXML(), PlanAutoGenerator.LOGGER_AUTOGEN);
                }
            }
            thePlan.setExecSteps(steps);
            thePlan.setDescription(this.generateAutogenPlanDescription(this.mComponent, this.mProcedureName, this.mProcedureType));
            this.addParams(thePlan, finalParamList);
            thePlan.setLimitToHostSet(this.mComponent.getLimitToHostSet());
            if (inShouldPersist) {
                if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                    Logger.debug("Saving plan...", PlanAutoGenerator.LOGGER_AUTOGEN);
                }
                ExecutionPlan planToSave = thePlan;
                Permissions tempPerms = new Permissions();
                tempPerms.add(new FolderPermission(SystemPluginConstants.getInstance().AUTOGEN_FOLDER_ID, "write"));
                tempPerms.add(new PluginMemberWritePermission(SystemPluginConstants.getInstance().SYSTEM_PLUGIN_ID));
                AccessControlContext acc = null;
                try {
                    acc = Server.getApp().getUserDBSubsystem().getAccessControlManager().addToCurrent(tempPerms);
                }
                catch (UnsupportedSubsystemException e) {
                    throw new PlanExecutionException(e);
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(this, planToSave){
                        private final /* synthetic */ ExecutionPlan val$planToSave;
                        private final /* synthetic */ PlanFinder this$0;
                        {
                            this.this$0 = this$0;
                            this.val$planToSave = val$planToSave;
                        }

                        public Object run() throws PersistenceManagerException, RPCException {
                            this.val$planToSave.save(null);
                            return null;
                        }
                    }, acc);
                }
                catch (PrivilegedActionException e) {
                    throw new PlanExecutionException(e.getCause());
                }
                thePlan = planToSave;
                PluginImplTable.DEFAULT.getClassMap().removeCacheObject(SystemPluginConstants.getInstance().SYSTEM_PLUGIN_ID);
                if (newAGPlanNeeded) {
                    AutoGeneratedPlan agPlan = new AutoGeneratedPlan(this.mComponent.getID(), thePlan.getID(), this.mProcedureName, this.mProcedureTarget, this.mProcedureType, 1);
                    if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                        Logger.debug("Saving plan marker: " + agPlan, PlanAutoGenerator.LOGGER_AUTOGEN);
                    }
                    agPlan.save();
                }
            }
            if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                Logger.debug("Plan finder returning plan:\n" + thePlan.writeToXML(), PlanAutoGenerator.LOGGER_AUTOGEN);
            }
            return thePlan;
        }

        private void addParams(ExecutionPlan plan, PromptParamList origParamList) {
            PromptParamList validParamList = new PromptParamList();
            String[] varNames = origParamList.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                PromptParam curParam = origParamList.getParam(varNames[i]);
                PromptParamList tmpParamList = new PromptParamList();
                tmpParamList.addParam(curParam);
                plan.setParams(tmpParamList);
                try {
                    ConfigGenerator.validatePlanParams(plan);
                }
                catch (ConfigGenException e) {
                    curParam = new PromptParam(curParam.getName(), null, curParam.getPrompt(), curParam.getDisplayMode());
                }
                validParamList.addParam(curParam);
            }
            plan.setParams(validParamList);
        }

        protected String generateAutogenPlanName(Component inComponent, String inProcedureName, NamedBlockType inProcedureType) {
            StringBuffer name = new StringBuffer();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            String token = inComponent.getName();
            if (token.length() > 245) {
                token = token.substring(0, 244);
            }
            name.append(token).append("-");
            if (inProcedureType != null) {
                if (inProcedureType.equals(NamedBlockType.INSTALL)) {
                    name.append(ROXMessageManager.messageAsString("pe.INSTALL_ABREV")).append("-");
                } else if (inProcedureType.equals(NamedBlockType.UNINSTALL)) {
                    name.append(ROXMessageManager.messageAsString("pe.UNINSTALL_ABREV")).append("-");
                } else if (inProcedureType.equals(NamedBlockType.CONTROL)) {
                    name.append(ROXMessageManager.messageAsString("pe.CALL_ABREV")).append("-");
                }
            }
            if ((token = inProcedureName) != null) {
                if (token.length() > 245) {
                    token = token.substring(0, 244);
                }
                name.append(token).append("-");
            }
            name.append(System.currentTimeMillis());
            if (Logger.isDebugEnabled(PlanAutoGenerator.LOGGER_AUTOGEN)) {
                Logger.debug("Plan finder generating plan name:" + name.toString(), PlanAutoGenerator.LOGGER_AUTOGEN);
            }
            return name.toString();
        }

        protected String generateAutogenPlanDescription(Component inComponent, String inProcedureName, NamedBlockType inProcedureType) {
            if (null != inProcedureType) {
                if (inProcedureType.equals(NamedBlockType.INSTALL)) {
                    return ROXMessageManager.messageAsString("pe.AUTOGENERATION_INSTALL_DESCRIPTION", new Object[]{inProcedureName, inComponent.getName()});
                }
                if (inProcedureType.equals(NamedBlockType.UNINSTALL)) {
                    return ROXMessageManager.messageAsString("pe.AUTOGENERATION_UNINSTALL_DESCRIPTION", new Object[]{inProcedureName, inComponent.getName()});
                }
                if (inProcedureType.equals(NamedBlockType.CONTROL)) {
                    return ROXMessageManager.messageAsString("pe.AUTOGENERATION_CALL_DESCRIPTION", new Object[]{inProcedureName, inComponent.getName()});
                }
            }
            return new String();
        }
    }
}

