/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionRunner;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotStepsContext;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.RealAgent;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.util.threads.Context;

public class NonPlanExecutionRunner
extends PlanExecutionRunner {
    private SnapshotStepsContext mRootContext;
    private RealAgent mAgent;
    private TaskExecutor mTaskExecutor;
    private Target mVATarget;

    public NonPlanExecutionRunner(Context inParent, ExecutionState inExecState, VACreationData vaData, SnapshotStepsContext inRootContext, TaskExecutor inTaskExecutor, RealAgent inAgent) throws PlanExecutionException {
        super(inParent, inExecState, vaData, 0);
        this.mRootContext = inRootContext;
        this.mAgent = inAgent;
        this.mVATarget = vaData.getTarget();
        this.mTaskExecutor = inTaskExecutor;
    }

    public SnapshotStepsContext getRootContext() {
        return this.mRootContext;
    }

    protected void checkTargetHasPermissions() {
    }

    protected void executeSteps(VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        this.mAgent.setTarget(this.mVATarget);
        try {
            this.doExecute(this.mRootContext, this.mExecState, this.mAgent);
        }
        catch (RPCException e) {
            throw new PlanExecutionException(e);
        }
    }

    private void doExecute(final SnapshotStepsContext context, final ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        RetargetingTaskExecutorBase.performRetargetableAction(new RetargetingTaskExecutorBase.RetargetableAction(){

            public Object execute(VirtualAgent inAgent) throws InterruptedException, PlanExecutionException, RPCException {
                NonPlanExecutionRunner.this.executeTargetSteps(inAgent, inState, context);
                return null;
            }
        }, context.getITarget(), null, inVirtualAgent, inState, null);
    }

    private void executeTargetSteps(VirtualAgent inVirtualAgent, ExecutionState inState, SnapshotStepsContext context) throws PlanExecutionException, InterruptedException, RPCException {
        ConfigGenerator configGen = TaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, context.getStepArgs(), context.getBlock(), context.getIComp(), TargetType.CURRENT, false, context.getCaller());
        ConfigGenerator passSafeConfigGen = TaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, context.getStepArgs(), context.getBlock(), context.getIComp(), TargetType.CURRENT, true, context.getCaller());
        this.performTestflow();
        MultiStepExecutor.execMultiStepsInCurrentComponent(null, context.getSteps(), inState, 0, inVirtualAgent, this.mTaskExecutor.getTaskExecutorFactory(null), context.getIComp(), configGen, passSafeConfigGen, context.getCaller());
        SnapshotStepsContext[] children = context.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.doExecute(children[i], inState, inVirtualAgent);
        }
    }
}

