/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepInfoTable;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.StepStatusQueryOrder;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.Vector;

public class MultiStepStatusQuery
extends MultiObjectQueryImplBase
implements PlanExecutorMessages,
MultiSelectableObjectQuery {
    private TargetID mTargetID;
    private HostID mHostID;
    private TaskID mTaskID;
    private RunLevel mRunLevel;
    private int mStepMap = -1;
    private StepID mStepID;
    private boolean mDoNotGroup = false;
    private boolean mGetChildrenOnly = false;
    private boolean mRetrieveExecNativeOutput = false;
    private boolean mTopLevelQuery = false;
    private ConditionalExpression mQueryConditional;
    private boolean mFailedHostsQuery = false;
    static final StepInfoTable stepInfo = new StepInfoTable("si");
    static final StepInfoTable innerStepInfo = new StepInfoTable("sii");
    static final TaskInfoTable taskInfo = new TaskInfoTable("ti");
    static final TargetSQLOps TARGET = new TargetSQLOps("target");
    private static final String MSG_QUERY_DURATION = "event.QUERY_DURATION";
    public static final String ORDERNAME_BY_STEPMAP_ASC = "stepmap+,hoststepmap+";
    public static final String ORDERNAME_BY_STEPMAP_ONLY_ASC = "stepmap+";
    public static final String ORDERNAME_BY_TARGETID_ASC = "targetid+";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$executor$PlanInterface;

    public static MultiStepStatusQuery topLevelSteps(TaskID inTaskID, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inRunLevel);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ONLY_ASC);
        mssq.mTopLevelQuery = true;
        return mssq;
    }

    public static MultiStepStatusQuery topLevelSteps(TaskID inTaskID) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, false);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ONLY_ASC);
        mssq.mTopLevelQuery = true;
        return mssq;
    }

    public static MultiStepStatusQuery topLevelSteps(TaskID inTaskID, TargetID inTargetID, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inTargetID, inRunLevel);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ONLY_ASC);
        mssq.mTopLevelQuery = true;
        return mssq;
    }

    public static MultiStepStatusQuery topLevelSteps(TaskID inTaskID, HostID inLogicalHostID, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inLogicalHostID, inRunLevel);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ONLY_ASC);
        mssq.mTopLevelQuery = true;
        return mssq;
    }

    public static MultiStepStatusQuery stepOnAllHosts(TaskID inTaskID, int inStepMap, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inStepMap, inRunLevel);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_TARGETID_ASC);
        return mssq;
    }

    public static MultiStepStatusQuery stepOnAllHosts(TaskID inTaskID, TargetID inTargetID, int inStepMap, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inTargetID, inStepMap, inRunLevel);
        return mssq;
    }

    public static MultiStepStatusQuery stepOnAllHosts(TaskID inTaskID, HostID inLogicalHostID, int inStepMap, RunLevel inRunLevel) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, inLogicalHostID, inStepMap, inRunLevel);
        return mssq;
    }

    public static MultiStepStatusQuery allSteps(StepID inStepID) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inStepID, false, true);
        return mssq;
    }

    public static MultiStepStatusQuery childrenOfThisStep(StepID inStepID) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inStepID, true, false);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ASC);
        return mssq;
    }

    public static MultiStepStatusQuery childrenOfThisTask(TaskID inTaskID) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(inTaskID, true);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ASC);
        return mssq;
    }

    public static MultiStepStatusQuery byIDs(StepID[] inIDs) {
        return new MultiStepStatusQuery(StepInfoTable.emptyIn(MultiStepStatusQuery.stepInfo.ID, StepInfoTable.rList(inIDs)));
    }

    public static MultiStepStatusQuery byTaskID(TaskID inTaskID) {
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.TaskID, inTaskID));
        mssq.setObjectOrder(StepStatusQueryOrder.BY_STEPMAP_ASC);
        return mssq;
    }

    public static MultiStepStatusQuery failedStepsForTask(TaskID inTaskID) {
        AndExp cond = stepInfo.and();
        cond.add(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.StepStatusAsString, StepStatus.INCOMPLETE_ERROR.toString()));
        cond.add(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.Handled, false));
        cond.add(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.TaskID, inTaskID));
        Select stepMapInner = stepInfo.select(StepInfoTable.sList(StepInfoTable.max(MultiStepStatusQuery.stepInfo.StepMap)), StepInfoTable.where(StepInfoTable.and(StepInfoTable.and(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.TaskID, inTaskID), StepInfoTable.equals(MultiStepStatusQuery.stepInfo.StepStatusAsString, StepStatus.INCOMPLETE_ERROR.toString())), StepInfoTable.equals(MultiStepStatusQuery.stepInfo.Handled, false))));
        cond.add(StepInfoTable.equals((ColumnNode)MultiStepStatusQuery.stepInfo.StepMap, stepMapInner));
        Select hostStepMapInner = stepInfo.select(StepInfoTable.sList(StepInfoTable.max(MultiStepStatusQuery.stepInfo.HostStepMap)), StepInfoTable.where(StepInfoTable.and(StepInfoTable.and(StepInfoTable.equals(MultiStepStatusQuery.stepInfo.TaskID, inTaskID), StepInfoTable.equals(MultiStepStatusQuery.stepInfo.StepStatusAsString, StepStatus.INCOMPLETE_ERROR.toString())), StepInfoTable.equals(MultiStepStatusQuery.stepInfo.Handled, false))));
        cond.add(StepInfoTable.equals((ColumnNode)MultiStepStatusQuery.stepInfo.HostStepMap, hostStepMapInner));
        MultiStepStatusQuery mssq = new MultiStepStatusQuery(cond);
        mssq.setObjectOrder(StepStatusQueryOrder.BY_HOSTNAME_ASC);
        mssq.mRetrieveExecNativeOutput = true;
        mssq.mFailedHostsQuery = true;
        return mssq;
    }

    public StepStatusBean[] select() throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        StepStatusBean[] result = this.getRows();
        if (!this.mDoNotGroup && result != null && result.length > 0) {
            TreeMap<Integer, StepStatusBean> newResults = new TreeMap<Integer, StepStatusBean>();
            for (int index = 0; index < result.length; ++index) {
                StepStatusBean currentValue = result[index];
                Integer key = new Integer(currentValue.getStepInfo().getStepMap());
                StepStatusBean oldValue = newResults.put(key, currentValue);
                if (null != oldValue) {
                    StepStatus preferredStatus = StepStatus.chooseStatus(currentValue.getStepInfo().getStepStatus(), oldValue.getStepInfo().getStepStatus());
                    currentValue.getStepInfo().setStepStatus(preferredStatus);
                }
                currentValue.getStepInfo().sanitize();
            }
            result = newResults.values().toArray(new StepStatusBean[0]);
        }
        if (null != result && result.length > 0) {
            result = this.setCountersForResult(result);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"StepStatusQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        return result;
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        StepStatusBean[] beans = this.select();
        HasObjectID[] result = new StepInfo[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            result[i] = beans[i].getStepInfo();
        }
        return result;
    }

    protected StepStatusBean[] setCountersForResult(StepStatusBean[] inRawResult) throws PersistenceManagerException, RPCException {
        StepStatusBean[] newResult = new StepStatusBean[inRawResult.length];
        for (int i = 0; i < inRawResult.length; ++i) {
            newResult[i] = inRawResult[i];
            StepCounterRetriever retriever = new StepCounterRetriever(newResult[i].getStepInfo().getTaskID(), newResult[i].getStepInfo().getStepMap(), newResult[i].getStepInfo().getHostStepMap(), newResult[i].getStepInfo().getRunLevel(), this.mTargetID, this.mHostID);
            newResult[i].getStepInfo().setHostsStarted(retriever.getStarted());
            newResult[i].getStepInfo().setHostsCompleted(retriever.getCompleted());
            newResult[i].getStepInfo().setHostsFailed(retriever.getFailed());
        }
        return newResult;
    }

    private StepStatusBean[] getRows() throws PersistenceManagerException, RPCException {
        StepStatusBeanResultSetProcessor resultProcessor = new StepStatusBeanResultSetProcessor(stepInfo, taskInfo, !this.mDoNotGroup, this.mHostID != null, this.mRetrieveExecNativeOutput, this.mTopLevelQuery);
        return (StepStatusBean[])this.selectArray(this.getSelectStatement(), resultProcessor, StepStatusBean.class);
    }

    private MultiStepStatusQuery(TaskID inTaskID, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mRunLevel = inRunLevel;
    }

    private MultiStepStatusQuery(TaskID inTaskID, boolean inChildrenOnly) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mDoNotGroup = inChildrenOnly;
        this.mGetChildrenOnly = inChildrenOnly;
    }

    private MultiStepStatusQuery(TaskID inTaskID, int inStepMap, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mStepMap = inStepMap;
        this.mRunLevel = inRunLevel;
        this.mDoNotGroup = true;
    }

    private MultiStepStatusQuery(TaskID inTaskID, TargetID inTargetID, int inStepMap, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mTargetID = inTargetID;
        this.mStepMap = inStepMap;
        this.mRunLevel = inRunLevel;
        this.mDoNotGroup = true;
    }

    private MultiStepStatusQuery(TaskID inTaskID, TargetID inTargetID, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mTargetID = inTargetID;
        this.mRunLevel = inRunLevel;
    }

    private MultiStepStatusQuery(TaskID inTaskID, HostID inHostID, int inStepMap, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mHostID = inHostID;
        this.mStepMap = inStepMap;
        this.mRunLevel = inRunLevel;
        this.mDoNotGroup = true;
    }

    private MultiStepStatusQuery(TaskID inTaskID, HostID inHostID, RunLevel inRunLevel) {
        super(StepStatusQueryOrder.FACTORY);
        this.mTaskID = inTaskID;
        this.mHostID = inHostID;
        this.mRunLevel = inRunLevel;
    }

    private MultiStepStatusQuery(StepID inStepID, boolean inGetChildrenOnly, boolean inRetrieveExecNativeOutput) {
        super(StepStatusQueryOrder.FACTORY);
        this.mStepID = inStepID;
        this.mGetChildrenOnly = inGetChildrenOnly;
        this.mDoNotGroup = true;
        this.mRetrieveExecNativeOutput = inRetrieveExecNativeOutput;
    }

    private MultiStepStatusQuery(ConditionalExpression cond) {
        super(StepStatusQueryOrder.FACTORY);
        this.mQueryConditional = cond;
        this.mDoNotGroup = true;
    }

    protected TableList getTableList() {
        if (this.mTopLevelQuery) {
            return QueryBuilder.tList(stepInfo);
        }
        if (this.mFailedHostsQuery) {
            return QueryBuilder.tList(stepInfo, taskInfo, TARGET);
        }
        return QueryBuilder.tList(stepInfo, (TableClause)taskInfo);
    }

    protected Select modifySelect(Select inSelectToModify) {
        if (this.mTopLevelQuery) {
            return QueryBuilder.distinct(inSelectToModify);
        }
        return inSelectToModify;
    }

    protected SelectList getSelectList() {
        if (this.mTopLevelQuery) {
            return QueryBuilder.sList(QueryBuilder.sList(QueryBuilder.sList(MultiStepStatusQuery.stepInfo.StepMap, MultiStepStatusQuery.stepInfo.Description, MultiStepStatusQuery.stepInfo.StepStatusAsString), QueryBuilder.sList(MultiStepStatusQuery.stepInfo.StepType, MultiStepStatusQuery.stepInfo.TargetCount, MultiStepStatusQuery.stepInfo.NestingLevel)), QueryBuilder.sList(MultiStepStatusQuery.stepInfo.ExecutionPlanID, MultiStepStatusQuery.stepInfo.TaskID, MultiStepStatusQuery.stepInfo.RunLevelAsString));
        }
        if (this.mFailedHostsQuery) {
            return QueryBuilder.sList(stepInfo.allColumns(), taskInfo.allColumns(), TARGET.allColumns());
        }
        return QueryBuilder.sList((SelectList)stepInfo.allColumns(), taskInfo.allColumns());
    }

    protected ConditionalExpression getWhereCondition() {
        AndExp where = QB.and();
        if (!this.mTopLevelQuery) {
            where.add(QueryBuilder.equals((ColumnNode)MultiStepStatusQuery.stepInfo.TaskID, MultiStepStatusQuery.taskInfo.ID));
        }
        if (this.mFailedHostsQuery) {
            where.add(QueryBuilder.equals((ColumnNode)MultiStepStatusQuery.stepInfo.TargetID, MultiStepStatusQuery.TARGET.ID));
        }
        if (null != this.mQueryConditional) {
            where.add(this.mQueryConditional);
        } else if (null != this.mStepID) {
            if (this.mGetChildrenOnly) {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.ParentStepID, this.mStepID));
            } else {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.ID, this.mStepID));
            }
        } else {
            where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.TaskID, this.mTaskID));
            if (null != this.mRunLevel) {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.RunLevelAsString, this.mRunLevel.toString()));
            }
            if (null != this.mTargetID) {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.TargetID, this.mTargetID));
            }
            if (null != this.mHostID) {
                where.add(QueryBuilder.in((ColumnNode)MultiStepStatusQuery.stepInfo.TargetID, TargetSQLOps.DEFAULT.selectIDsByHost(this.mHostID, TargetType.INITIAL)));
            }
            if (-1 != this.mStepMap) {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.StepMap, this.mStepMap));
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.Mappable, true));
            } else if (!this.mDoNotGroup) {
                where.add(QueryBuilder.equals(MultiStepStatusQuery.stepInfo.Mappable, true));
            }
        }
        return where;
    }

    public void setRetrieveExecNativeOutput(boolean inRetrieve) {
        this.mRetrieveExecNativeOutput = inRetrieve;
    }

    private static final class StepCounterBeanResultSetProcessor
    extends ResultProcessor {
        public Object processRow(ResultSet inResultSet) throws SQLException {
            Vector<Integer> result = new Vector<Integer>();
            result.add(new Integer(IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount() - 2)));
            result.add(new Integer(IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount() - 1)));
            result.add(new Integer(IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount())));
            return result;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }

    private static class StepCounterRetriever
    extends QueryBuilder {
        private int mStarted = 0;
        private int mCompleted = 0;
        private int mFailed = 0;

        protected StepCounterRetriever(TaskID inTaskID, int inStepMap, int inHostStepMap, RunLevel inRunLevel, TargetID inTargetID, HostID inHostID) throws PersistenceManagerException {
            this.retrieveCounters(inTaskID, inStepMap, inHostStepMap, inRunLevel, inTargetID, inHostID);
        }

        protected void retrieveCounters(TaskID inTaskID, int inStepMap, int inHostStepMap, RunLevel inRunLevel, TargetID inTargetID, HostID inHostID) throws PersistenceManagerException {
            StepInfoTable stepInfo = new StepInfoTable("csi");
            AndExp scalarWhere = StepCounterRetriever.and();
            scalarWhere.add(StepCounterRetriever.equals(stepInfo.TaskID, inTaskID));
            scalarWhere.add(StepCounterRetriever.equals(stepInfo.StepMap, inStepMap));
            if (inHostStepMap != -1) {
                scalarWhere.add(StepCounterRetriever.equals(stepInfo.HostStepMap, inHostStepMap));
            } else {
                scalarWhere.add(StepCounterRetriever.equals(stepInfo.Mappable, true));
            }
            scalarWhere.add(StepCounterRetriever.equals(stepInfo.RunLevelAsString, inRunLevel.toString()));
            if (null != inTargetID) {
                scalarWhere.add(StepCounterRetriever.equals(stepInfo.TargetID, inTargetID));
            }
            if (null != inHostID) {
                scalarWhere.add(StepCounterRetriever.in((ColumnNode)stepInfo.TargetID, TargetSQLOps.DEFAULT.selectIDsByHost(inHostID, TargetType.INITIAL)));
            }
            SelectList selectList = StepCounterRetriever.sList(StepCounterRetriever.sum(stepInfo.HostsStarted), StepCounterRetriever.sum(stepInfo.HostsCompleted), StepCounterRetriever.sum(stepInfo.HostsFailed));
            StepCounterBeanResultSetProcessor statusProcessor = new StepCounterBeanResultSetProcessor();
            StepCounterRetriever.execute(QueryBuilder.select(selectList, StepCounterRetriever.tList(stepInfo), StepCounterRetriever.where(scalarWhere)), statusProcessor);
            Vector metaResults = statusProcessor.getResults();
            Vector results = (Vector)metaResults.get(0);
            this.mStarted = (Integer)results.get(0);
            this.mCompleted = (Integer)results.get(1);
            this.mFailed = (Integer)results.get(2);
        }

        protected int getStarted() {
            return this.mStarted;
        }

        protected int getCompleted() {
            return this.mCompleted;
        }

        protected int getFailed() {
            return this.mFailed;
        }
    }

    private static final class StepStatusBeanResultSetProcessor
    extends ResultProcessor {
        StepInfoTable mStepTable;
        TaskInfoTable mTaskTable;
        boolean mRetrieveChildren;
        boolean mFilteredByHost;
        boolean mRetrieveExecNativeOutput;
        boolean mTopLevelQuery;

        public StepStatusBeanResultSetProcessor(StepInfoTable inStepInfoTable, TaskInfoTable inTaskInfoTable, boolean inRetrieveChildren, boolean inFilteredByHost, boolean inRetrieveExecNativeOutput, boolean inTopLevelQuery) {
            this.mStepTable = inStepInfoTable;
            this.mTaskTable = inTaskInfoTable;
            this.mRetrieveChildren = inRetrieveChildren;
            this.mFilteredByHost = inFilteredByHost;
            this.mRetrieveExecNativeOutput = inRetrieveExecNativeOutput;
            this.mTopLevelQuery = inTopLevelQuery;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            TaskInfo taskInfo = null;
            StepInfo stepInfo = null;
            StepStatusBean bean = null;
            if (this.mTopLevelQuery) {
                stepInfo = new StepInfo();
                stepInfo.setStepMap(inResultSet.getInt(1));
                stepInfo.setDescription(inResultSet.getString(2));
                stepInfo.setStepStatus(StepStatus.FACTORY.get(inResultSet.getString(3)));
                stepInfo.setStepType(inResultSet.getInt(4));
                stepInfo.setTargetCount(inResultSet.getInt(5));
                stepInfo.setNestingLevel(inResultSet.getInt(6));
                stepInfo.setExecutionPlanID(new ExecutionPlanID(inResultSet.getString(7)));
                stepInfo.setTaskID(new TaskID(inResultSet.getString(8)));
                stepInfo.setRunLevel(RunLevel.FACTORY.get(inResultSet.getString(9)));
                bean = new StepStatusBean(stepInfo);
            } else {
                taskInfo = this.mTaskTable.retrieveObject(inResultSet);
                stepInfo = this.mStepTable.retrieveObject(inResultSet);
                stepInfo.setTaskInfo(taskInfo);
                TaskStatusBean taskStatus = new TaskStatusBean(taskInfo);
                bean = new StepStatusBean(taskStatus, stepInfo);
                if (this.mRetrieveExecNativeOutput && (stepInfo.getStepType() == 103 || stepInfo.getStepType() == 123)) {
                    ExecNativeOutput nativeOutput = null;
                    try {
                        PlanInterface planInterface = (PlanInterface)Server.getApp().getNetSubsystem().getRPC().getLocalService(Server.getApp().getNetSubsystem().getMSAddress(), class$com$raplix$rolloutexpress$executor$PlanInterface == null ? (class$com$raplix$rolloutexpress$executor$PlanInterface = MultiStepStatusQuery.class$("com.raplix.rolloutexpress.executor.PlanInterface")) : class$com$raplix$rolloutexpress$executor$PlanInterface);
                        nativeOutput = planInterface.getExecOutput(bean.getStepInfo().getStepID());
                    }
                    catch (ConfigurationException ce) {
                        throw new PersistenceManagerException(ce);
                    }
                    catch (TransportException te) {
                        throw new PersistenceManagerException(te);
                    }
                    catch (RPCException rpce) {
                        throw new PersistenceManagerException(rpce);
                    }
                    catch (PlanExecutionException pee) {
                        // empty catch block
                    }
                    bean.setExecNativeOutput(nativeOutput);
                }
                if (this.mFilteredByHost) {
                    bean.getStepInfo().setTargetCount(1);
                    bean.getStepInfo().setCountersFromStatus();
                }
                if (this.mRetrieveChildren) {
                    try {
                        if (bean.getStepInfo().canHaveChildren()) {
                            bean.getStepInfo().getChildren(true);
                        }
                    }
                    catch (Exception e) {
                        throw new PersistenceManagerException(e);
                    }
                }
            }
            return bean;
        }
    }
}

