/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.task.TaskExecutorFactory;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.util.logger.Logger;

public class MultiStepExecutor
implements PlanExecutorMessages {
    private static final String LOGGER_CATEGORY = MultiStepExecutor.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnStep execMultiStepsInCurrentComponent(StepInfo inStepInfo, ExecStep[] inExecSteps, ExecutionState inExecState, int inStepPointer, VirtualAgent inVirtualAgent, TaskExecutorFactory inFactory, InstalledComponent inInstalledComponent, ConfigGenerator inNewCG, ConfigGenerator inPasswdSafeCG, Caller inNextCaller) throws InterruptedException, PlanExecutionException {
        inExecState.pushInstalledCompAndCaller(inInstalledComponent, inNextCaller);
        ConfigGenerator oldCG = null;
        ConfigGenerator oldPasswdSafeCG = null;
        if (inNewCG != null) {
            oldCG = inExecState.getCurrConfigGenerator();
            inExecState.setCurrConfigGenerator(inNewCG);
        }
        if (inPasswdSafeCG != null) {
            oldPasswdSafeCG = inExecState.getCurrPasswdSafeConfigGenerator();
            inExecState.setCurrPasswdSafeConfigGenerator(inPasswdSafeCG);
        }
        try {
            ReturnStep returnStep = MultiStepExecutor.execMultiSteps(inStepInfo, inExecSteps, inExecState, inStepPointer, inVirtualAgent, inFactory);
            Object var14_13 = null;
            inExecState.popInstalledCompAndCaller();
            if (inNewCG != null) {
                inExecState.setCurrConfigGenerator(oldCG);
            }
            if (inPasswdSafeCG != null) {
                inExecState.setCurrPasswdSafeConfigGenerator(oldPasswdSafeCG);
            }
            return returnStep;
        }
        catch (Throwable throwable) {
            block7: {
                Object var14_14 = null;
                inExecState.popInstalledCompAndCaller();
                if (inNewCG != null) {
                    inExecState.setCurrConfigGenerator(oldCG);
                }
                if (inPasswdSafeCG == null) break block7;
                inExecState.setCurrPasswdSafeConfigGenerator(oldPasswdSafeCG);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnStep execMultiStepsOnNewTarget(StepInfo inStepInfo, ExecStep[] inExecSteps, ExecutionState inExecState, int inStepPointer, VirtualAgent inVirtualAgent, TaskExecutorFactory inFactory, Host inNewCurrentHost, VariableSettingsSource inVarScope) throws InterruptedException, PlanExecutionException, ConfigGenException {
        PlanTargetedConfigContext planCtx = inExecState.getCurrPlanTargetedCtx();
        Host oldCurHost = planCtx.getTargetHost();
        if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
            Logger.debug("Setting targetHost to " + inNewCurrentHost.getName(), LOGGER_CATEGORY);
        }
        planCtx.setTargetHost(inNewCurrentHost);
        ConfigGenerator oldCG = inExecState.getCurrConfigGenerator();
        ConfigGenerator oldPasswdSafeCG = inExecState.getCurrPasswdSafeConfigGenerator();
        inExecState.setCurrConfigGenerator(oldCG.newUnresVarScope(inVarScope));
        inExecState.setCurrPasswdSafeConfigGenerator(oldPasswdSafeCG.newUnresVarScope(inVarScope));
        try {
            ReturnStep returnStep = MultiStepExecutor.execMultiSteps(inStepInfo, inExecSteps, inExecState, inStepPointer, inVirtualAgent, inFactory);
            Object var14_13 = null;
            inExecState.setCurrConfigGenerator(oldCG);
            inExecState.setCurrPasswdSafeConfigGenerator(oldPasswdSafeCG);
            planCtx.setTargetHost(oldCurHost);
            return returnStep;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            inExecState.setCurrConfigGenerator(oldCG);
            inExecState.setCurrPasswdSafeConfigGenerator(oldPasswdSafeCG);
            planCtx.setTargetHost(oldCurHost);
            throw throwable;
        }
    }

    public static ReturnStep execMultiSteps(StepInfo inStepInfo, ExecStep[] inExecSteps, ExecutionState inExecState, int inStepPointer, VirtualAgent inVirtualAgent, TaskExecutorFactory inFactory) throws InterruptedException, PlanExecutionException {
        ReturnStep returnStep = null;
        if (inExecSteps != null) {
            if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
                Logger.debug("In " + inVirtualAgent.getRunLevel() + ", MSE given the following " + inExecSteps.length + " step(s) to execute:", LOGGER_CATEGORY);
                for (int i = 0; i < inExecSteps.length; ++i) {
                    Logger.debug(inExecSteps[i].toString(), LOGGER_CATEGORY);
                }
            }
            for (int stepPointer = 0; stepPointer < inExecSteps.length; ++stepPointer) {
                TaskExecutor theTask;
                ExecStep currentStep = inExecSteps[inStepPointer];
                if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
                    Logger.debug("MSE now executing " + inExecSteps[inStepPointer], LOGGER_CATEGORY);
                }
                inExecState.getPER().performTestflow();
                if (null != inStepInfo && -1 == currentStep.getStepMap() && inStepInfo.getChildrenMappable()) {
                    currentStep.setStepMap(inStepInfo.assignSubstepCounter());
                    if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
                        Logger.debug("Current step is a mappable child step and is assigned step map: " + currentStep.getStepMap(), LOGGER_CATEGORY);
                    }
                }
                StepInfo newStep = inExecState.getPlanRecorder().findStep(currentStep.getStepMap(), inVirtualAgent.getTargetID(), inVirtualAgent.getRunLevel());
                if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
                    Logger.debug("MSE has tried to search for the current StepInfo in the existing steps from the compiler and found: " + newStep, LOGGER_CATEGORY);
                }
                if ((theTask = MultiStepExecutor.dispatchStep(currentStep, inExecState, inFactory, inVirtualAgent, inStepInfo, newStep)).getReturnStep() != null) {
                    returnStep = theTask.getReturnStep();
                }
                if (currentStep instanceof ReturnStep) {
                    returnStep = (ReturnStep)currentStep;
                }
                ++inStepPointer;
                if (returnStep != null) break;
            }
        }
        return returnStep;
    }

    private static TaskExecutor dispatchStep(ExecStep inStep, ExecutionState inExecState, TaskExecutorFactory inTEFactory, VirtualAgent inVirtualAgent, StepInfo inParentStep, StepInfo inCurrentStep) throws PlanExecutionException {
        TaskExecutor theTask = inTEFactory.getTaskExecutor(inExecState.getApp(), inStep);
        if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
            Logger.debug("Dispatching step " + inStep + " with current StepInfo:\n" + inCurrentStep + "\nas child of:\n" + inParentStep, LOGGER_CATEGORY);
        }
        theTask.execute(inExecState, inVirtualAgent, inParentStep, inCurrentStep);
        return theTask;
    }
}

