/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledPlanTraverser;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.IfStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RetargetStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TryStep;
import com.raplix.util.logger.Logger;

public abstract class InstallStepGathererTraverser
implements CompiledPlanTraverser {
    public void stepEncountered(int inStepNum, ExecStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("looking at step " + ExecStep.getStepTypeStringRepresentation(inStep.getStepType()), this);
        }
        switch (inStep.getStepType()) {
            case 105: {
                this.handleInstallStep((InstallStep)inStep, inStepNum, inSubplan, inPlan);
                break;
            }
            case 128: {
                this.handleRetargetStep((RetargetStep)inStep, inStepNum, inSubplan, inPlan);
                break;
            }
            case 127: {
                this.handleIfStep((IfStep)inStep, inStepNum, inSubplan, inPlan);
                break;
            }
            case 125: {
                this.handleTryStep((TryStep)inStep, inStepNum, inSubplan, inPlan);
            }
        }
    }

    protected abstract void handleInstallStep(InstallStep var1, int var2, CompiledSimpleSubplan var3, CompiledPlan var4) throws PlanExecutionException;

    protected void handleIfStep(IfStep inIfStep, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        this.traverseSubSteps(inIfStep.getThenSteps(), inStepNum, inSubplan, inPlan);
        this.traverseSubSteps(inIfStep.getElseSteps(), inStepNum, inSubplan, inPlan);
    }

    protected void handleRetargetStep(RetargetStep inRetargetStep, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        this.traverseSubSteps(inRetargetStep.getSteps(), inStepNum, inSubplan, inPlan);
    }

    protected void handleTryStep(TryStep inTryStep, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        this.traverseSubSteps(inTryStep.getTrySteps(), inStepNum, inSubplan, inPlan);
        this.traverseSubSteps(inTryStep.getCatchSteps(), inStepNum, inSubplan, inPlan);
        this.traverseSubSteps(inTryStep.getFinallySteps(), inStepNum, inSubplan, inPlan);
    }

    private void traverseSubSteps(ExecStep[] inSteps, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        if (inSteps == null) {
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Traversing children for composite step " + inStepNum, this);
        }
        for (int i = 0; i < inSteps.length; ++i) {
            this.stepEncountered(inStepNum, inSteps[i], inSubplan, inPlan);
        }
    }
}

