/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportControl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;
import java.util.Hashtable;

public class HeartbeatPinger
extends RunnableContext {
    private Hashtable mHosts = new Hashtable();
    private TransportControl mTransportControl;
    public static final int SLEEP_TIME_MILLIS = 60000;

    public HeartbeatPinger(Context inParent, TransportControl inTPC) {
        super("heartbeatPinger", inParent);
        this.mTransportControl = inTPC;
    }

    public void addPingHost(Host inHost) {
        Host result = this.mHosts.put(inHost.getID(), inHost);
        if (result != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("readding host : " + inHost.getName(), this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("first time adding host " + inHost.getName(), this);
        }
    }

    public void removePingHost(Host inHost) {
        Object result = this.mHosts.remove(inHost.getID());
        if (result == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("tried removing host: " + inHost.getName() + " but it's not being pinged", this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("removed host: " + inHost.getName() + " from pinger", this);
        }
    }

    public Host[] getHostList() {
        return this.mHosts.values().toArray(new Host[this.mHosts.size()]);
    }

    protected void safeRun() throws Exception {
        while (true) {
            this.testFlow();
            Host[] allHosts = this.getHostList();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("found " + allHosts.length + " hosts to ping", this);
            }
            for (int i = 0; i < allHosts.length; ++i) {
                try {
                    RoxAddress address = allHosts[i].getAppRA().getRoxAddress();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Pinging host " + allHosts[i].getName() + " at address " + address, this);
                    }
                    this.mTransportControl.pingAsync(address);
                }
                catch (RaplixException ex) {
                    Logger.error(ex.getMessage(), ex, this);
                }
                this.testFlow();
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("sleeping...", this);
            }
            Thread.currentThread();
            Thread.sleep(60000L);
        }
    }

    public void release() throws Exception {
        super.release();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("HeartbeatPinger quitting", this);
        }
    }
}

