/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.PlanExecutionRunner;
import com.raplix.rolloutexpress.executor.PlanRecorder;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.util.logger.Logger;
import java.util.Stack;

public class ExecutionState {
    private Stack mCIDStack;
    private Stack mCallerStack;
    private Application mApp;
    private NotificationManager mNotificationManager;
    private NetSubsystem mNet;
    private ResourceSubsystem mRsrcMgr;
    private InstallDBSubsystem mInstallDB;
    private ConfigGenSubsystem mCGMgr;
    private RunLevel mRunLevel;
    private CompiledSimpleSubplan mSubplan;
    private PlanExecutionRunner mPER;
    private Exception mFailureException;
    private TaskInfo mTaskInfo;
    private int mSnapshotInstallOrder = 1;
    private Stack mICompStack;
    private PlanTargetedConfigContext mPlanTargetedCtx;
    private ConfigGenerator mCurrCG;
    private ConfigGenerator mNoPasswdCG;
    private String mDefaultParentDirUser;
    private String mDefaultParentDirGroup;
    private PlanRecorder mPlanRecorder;
    private String mWorkingDirOverride = null;
    private ConfigGenerator mTopLevelSessionConfig;
    private ConfigGenerator mTopLevelPassSafeSessionConfig;

    public ExecutionState(Application inApp, CompiledSimpleSubplan inPlan, TaskInfo inTaskInfo, RunLevel inRunLevel) throws UnsupportedSubsystemException {
        this(inApp, inPlan, inTaskInfo, inRunLevel, null, null);
    }

    public ExecutionState(Application inApp, CompiledSimpleSubplan inPlan, TaskInfo inTaskInfo, RunLevel inRunLevel, ConfigGenerator topLevelSessionCG, ConfigGenerator topLevelPassSafeCG) throws UnsupportedSubsystemException {
        this.mApp = inApp;
        this.mSubplan = inPlan;
        this.mTaskInfo = inTaskInfo;
        this.mRunLevel = inRunLevel;
        this.mPER = null;
        this.mICompStack = new Stack();
        this.mCIDStack = new Stack();
        this.mCallerStack = new Stack();
        this.mPlanTargetedCtx = null;
        this.mNotificationManager = this.mApp.getNotificationManager();
        this.mNet = this.mApp.getNetSubsystem();
        this.mRsrcMgr = this.mApp.getResourceSubsystem();
        this.mInstallDB = this.mApp.getInstallDBSubsystem();
        this.mCGMgr = this.mApp.getConfigGenSubsystem();
        this.mTopLevelSessionConfig = topLevelSessionCG == null ? this.mCGMgr.getConfigGenerator() : topLevelSessionCG;
        this.mTopLevelPassSafeSessionConfig = topLevelPassSafeCG == null ? this.mCGMgr.getConfigGenerator() : topLevelPassSafeCG;
        PlanSubsystem planSub = this.mApp.getPlanSubsystem();
        try {
            this.mDefaultParentDirUser = planSub.getConfigInstallUser();
            this.mDefaultParentDirGroup = planSub.getConfigInstallGroup();
        }
        catch (ConfigurationException ex) {
            throw new UnsupportedSubsystemException(ex);
        }
    }

    public Application getApp() {
        return this.mApp;
    }

    public RunLevel getRunLevel() {
        return this.mRunLevel;
    }

    public Exception getFailureException() {
        return this.mFailureException;
    }

    public ExecutionPlanData getPlan() {
        return this.mSubplan.getPlanData();
    }

    public CompiledSimpleSubplan getCompiledSubplan() {
        return this.mSubplan;
    }

    NotificationManager getNotificationManager() {
        return this.mNotificationManager;
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNet;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mRsrcMgr;
    }

    public InstallDBSubsystem getInstallDB() {
        return this.mInstallDB;
    }

    public ConfigGenSubsystem getConfigGenMgr() {
        return this.mCGMgr;
    }

    public PlanRecorder getPlanRecorder() {
        return this.mPlanRecorder;
    }

    public TaskID getTaskID() {
        return this.mTaskInfo.getTaskID();
    }

    public int getSnapshotInstallOrder() {
        return this.mSnapshotInstallOrder;
    }

    public void incrementSnapshotInstallOrder() {
        ++this.mSnapshotInstallOrder;
    }

    public PlanExecutionRunner getPER() {
        return this.mPER;
    }

    public ComponentInstallData getCurrPlanInitiatedInstallStepCID(InstallStep inStep) {
        ComponentInstallData outCID = (ComponentInstallData)inStep.getClientData();
        if (outCID == null) {
            ROXMessage msg = new ROXMessage("pe.ERR_NO_CID_STEP", inStep.toString());
            throw new NullPointerException(msg.toString());
        }
        return outCID.cloneForHost();
    }

    public TaskInfo getTaskInfo() {
        return this.mTaskInfo;
    }

    public void setPER(PlanExecutionRunner inPER) {
        this.mPER = inPER;
    }

    public void setFailureException(Exception inEx) {
        this.mFailureException = inEx;
    }

    public void setPlanRecorder(PlanRecorder inPlanRecorder) {
        this.mPlanRecorder = inPlanRecorder;
    }

    public void setWorkingDirOverride(String inOverride) {
        this.mWorkingDirOverride = inOverride;
    }

    public void pushInstalledCompAndCaller(InstalledComponent inInstalledComponent, Caller inCaller) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Pushing on callStack " + inCaller, this);
        }
        this.mICompStack.push(inInstalledComponent);
        this.mCallerStack.push(inCaller);
    }

    public void popInstalledCompAndCaller() {
        this.mICompStack.pop();
        this.mCallerStack.pop();
    }

    public InstalledComponent getCurrInstalledComponent() {
        if (this.mICompStack.empty()) {
            return null;
        }
        InstalledComponent installedComponent = (InstalledComponent)this.mICompStack.peek();
        return installedComponent;
    }

    public ComponentInstallData getCurrCID() {
        if (this.mCIDStack.empty()) {
            return null;
        }
        return (ComponentInstallData)this.mCIDStack.peek();
    }

    public void pushCID(ComponentInstallData inCID) {
        this.mCIDStack.push(inCID);
    }

    public ComponentInstallData popCID() {
        return (ComponentInstallData)this.mCIDStack.pop();
    }

    public void setPlanTargetedCtx(PlanTargetedConfigContext inCtx) {
        this.mPlanTargetedCtx = inCtx;
    }

    public PlanTargetedConfigContext getCurrPlanTargetedCtx() {
        return this.mPlanTargetedCtx;
    }

    public ConfigGenerator getCurrConfigGenerator() {
        return this.mCurrCG;
    }

    public ConfigGenerator getCurrPasswdSafeConfigGenerator() {
        return this.mNoPasswdCG;
    }

    public void setCurrPasswdSafeConfigGenerator(ConfigGenerator inCG) {
        this.mNoPasswdCG = inCG;
    }

    public void setCurrConfigGenerator(ConfigGenerator inCG) {
        this.mCurrCG = inCG;
    }

    public String getDefaultParentDirUser() {
        return this.mDefaultParentDirUser;
    }

    public String getDefaultParentDirGroup() {
        return this.mDefaultParentDirGroup;
    }

    public String getWorkingDirOverride() {
        return this.mWorkingDirOverride;
    }

    public ConfigGenerator getTopLevelSessionConfigGen() {
        return this.mTopLevelSessionConfig;
    }

    public ConfigGenerator getTopLevelPassSafeSessionConfigGen() {
        return this.mTopLevelPassSafeSessionConfig;
    }

    public Caller getCaller() {
        InstalledComponent iComp;
        Caller theCaller = this.getCurrCaller();
        if (theCaller == null && (iComp = this.getCurrInstalledComponent()) == null) {
            return this.getCompiledSubplan().getExecutionPlan().toCaller();
        }
        if (theCaller == null) {
            NullPointerException ex = new NullPointerException("got an NPE caller while installedcomponent is " + this.getCurrInstalledComponent());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("got an NPE", ex, this);
            }
            throw ex;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Returning caller " + theCaller.getActualComponent().getName() + ", declaring: " + theCaller.getDeclaredComponent().getName(), this);
        }
        return theCaller;
    }

    private Caller getCurrCaller() {
        if (this.mCallerStack.empty()) {
            return null;
        }
        return (Caller)this.mCallerStack.peek();
    }
}

