/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanCompiler;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInvoker;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import java.util.Stack;

public class CompiledSimpleSubplan
implements RPCSerializable {
    private SubplanInvoker[] mCallingChain;
    private SubplanInvoker mPlanCaller;
    private int mSubplanIndex;
    private ExecStep[] mExecSteps = null;
    private transient ExecutionState mState = null;

    public CompiledSimpleSubplan(SubplanInvoker inInvoker, Stack inCallingChain, int inSubplanIndex) {
        this.mCallingChain = inCallingChain.toArray(new SubplanInvoker[0]);
        this.mPlanCaller = inInvoker;
        this.mSubplanIndex = inSubplanIndex;
    }

    private CompiledSimpleSubplan() {
    }

    public ExecutionPlanData getPlanData() {
        return this.mPlanCaller.getPlanData();
    }

    public ExecutionPlan getExecutionPlan() {
        Stack<SubplanInvoker> callingChain = this.getCallingChain();
        if (callingChain == null) {
            callingChain = new Stack<SubplanInvoker>();
        }
        callingChain.push(this.mPlanCaller);
        return PlanCompiler.getNonInlineCallingPlan(callingChain);
    }

    public ExecStep[] getExecSteps() {
        if (this.mExecSteps == null) {
            this.mExecSteps = this.getPlanData().getExecSteps();
        }
        return this.mExecSteps;
    }

    public ExecutionPlanID getSubplanPlanID() {
        return this.mPlanCaller.getSubplanPlanID();
    }

    public ExecStep getInvokingStep() {
        return this.mPlanCaller.getInvokingStep();
    }

    public int getSubplanIndex() {
        return this.mSubplanIndex;
    }

    public Stack getCallingChain() {
        return (Stack)CollectionUtil.mapClass(this.mCallingChain, Stack.class);
    }

    public ExecutionMode getSubplanExecutionMode() {
        return this.mPlanCaller.getPlanData().getExecutionMode();
    }

    public String getName() {
        ExecutionPlanData theData = this.mPlanCaller.getPlanData();
        if (theData instanceof ExecutionPlan) {
            return ((ExecutionPlan)theData).getFullName();
        }
        return theData.getName();
    }

    public void setExecutionState(ExecutionState inState) {
        this.mState = inState;
    }

    public ExecutionState getExecutionState() {
        return this.mState;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof CompiledSimpleSubplan) {
            return this.equals((CompiledSimpleSubplan)other);
        }
        return false;
    }

    public ConfigGenerator createCGForSubplan(ConfigGenerator inStartingCG, VirtualAgent inAgent, ExecutionState inState, ConfigGenManager inCGMgr, boolean inHidePasswords) throws PlanExecutionException {
        Stack chain = this.getCallingChain();
        SubplanInvoker[] allInvokers = chain.toArray(new SubplanInvoker[chain.size()]);
        ConfigGenerator curCG = inStartingCG;
        try {
            for (int i = 0; i < allInvokers.length; ++i) {
                curCG = allInvokers[i].pushNewCallScopes(curCG, inAgent, inState, inCGMgr, inHidePasswords);
            }
            curCG = this.mPlanCaller.pushNewCallScopes(curCG, inAgent, inState, inCGMgr, inHidePasswords);
            return curCG;
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public boolean equals(CompiledSimpleSubplan inCSubplan) {
        if (inCSubplan == null) {
            return false;
        }
        if (inCSubplan.getSubplanIndex() != this.getSubplanIndex()) {
            return false;
        }
        if (this.getPlanData() == null ? inCSubplan.getPlanData() != null : inCSubplan.getPlanData() == null) {
            return false;
        }
        if (inCSubplan.getPlanData().equalsPlanData(this.mPlanCaller.getPlanData())) {
            // empty if block
        }
        if (!Util.isEqual(this.getSubplanExecutionMode(), inCSubplan.getSubplanExecutionMode())) {
            return false;
        }
        return this.isCallingChainEqual(inCSubplan);
    }

    private boolean isCallingChainEqual(CompiledSimpleSubplan inCSubplan) {
        Stack inCallingChain = inCSubplan.getCallingChain();
        if (this.mCallingChain == null ? inCallingChain != null : inCallingChain == null) {
            return false;
        }
        if (inCallingChain.size() != this.mCallingChain.length) {
            return false;
        }
        for (int i = 0; i < this.mCallingChain.length; ++i) {
            SubplanInvoker caller1 = this.mCallingChain[i];
            SubplanInvoker caller2 = (SubplanInvoker)inCallingChain.get(i);
            if (caller1 == null ? caller2 != null : caller2 == null) {
                return false;
            }
            if (caller1.getPlanData().equalsPlanData(caller2.getPlanData())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SubplanName: ").append(this.mPlanCaller.getPlanData().getName()).append(" Index: ").append(this.mSubplanIndex);
        buf.append(" ExecMode ").append(this.getSubplanExecutionMode()).append(" Calling Chain: [");
        for (int i = 0; i < this.mCallingChain.length; ++i) {
            ExecutionPlanData currPlan = this.mCallingChain[i].getPlanData();
            buf.append(currPlan.getName() + "-->");
        }
        buf.append("] Calling Step: ").append(this.mPlanCaller.getInvokingStep());
        return buf.toString();
    }
}

