/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.executor.BasicPlanRecorder;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HeartbeatPinger;
import com.raplix.rolloutexpress.executor.PETransaction;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.PlanExecutionRunner;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.PlanTimeoutException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.eventhandlers.EventHandlerTaskListener;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.plandb.DisplayMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.ContextThrottleMonitor;
import com.raplix.util.threads.RunnableContext;
import java.util.Vector;

public class CompiledPlanExecutor
extends RunnableContext
implements PlanExecutorMessages {
    public static final String HIDE_PASSWORD_VALUE = "*****";
    private Application mApp;
    private NotificationManager mNotificationMgr;
    private PlanSubsystem mPlanSubsystem;
    private ConfigGenManager mCGMgr;
    private UserDBSubsystem mUserDB;
    private PersistenceManager mPM;
    private CompiledPlan mPlan;
    protected ConfigGenerator mTopLevelCG;
    protected ConfigGenerator mTopLevelPasswdSafeCG;
    private TaskInfo mTaskInfo;
    private RunLevel mCurrentRunLevel = RunLevel.PREFLIGHT;
    private boolean mSentPreflightComplete = false;
    private Throwable mFailureException;
    private EventHandlerTaskListener mTaskListener;
    private HeartbeatPinger mHbtPinger;
    private ConfigGenerator mTopLevelSessionCG;
    private ConfigGenerator mTopLevelPassSafeSessionCG;

    public CompiledPlanExecutor(TaskInfo inTaskInfo, Context inParentContext, Application inApp) throws UnsupportedSubsystemException {
        super(inTaskInfo.getTaskID().toString(), inParentContext);
        this.mApp = inApp;
        this.mTaskInfo = inTaskInfo;
        this.mPlan = this.mTaskInfo.getCompiledPlan();
        this.mNotificationMgr = this.mApp.getNotificationManager();
        this.mPlanSubsystem = this.mApp.getPlanSubsystem();
        this.mCGMgr = this.mApp.getConfigGenSubsystem();
        this.mUserDB = this.mApp.getUserDBSubsystem();
        this.mPM = this.mApp.getPMSubsystem();
        this.mHbtPinger = new HeartbeatPinger(this, this.mApp.getNetSubsystem().getTransport().getControl());
    }

    protected void addHeartbeatHost(Host inHost) {
        this.mHbtPinger.addPingHost(inHost);
    }

    protected void removeHeartbeatHost(Host inHost) {
        this.mHbtPinger.removePingHost(inHost);
    }

    public void abort() {
        this.mTaskInfo.setTaskWasAborted();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("received abort call", this);
        }
        super.abort();
    }

    public void failed(Throwable t) {
        super.failed(t);
        this.mFailureException = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        Object v1;
        this.mHbtPinger.abort();
        try {
            block23: {
                int newStatus = 2;
                if (this.mTaskInfo.getTaskWasAborted()) {
                    newStatus = 4;
                }
                this.setTargetsToStatus(this.mTaskInfo, 3, newStatus);
                try {
                    this.mTaskInfo.save();
                    Object var3_2 = null;
                    if (!this.mSentPreflightComplete) {
                        this.sendNotification(ROXTaskEvent.preflightComplete(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID()), true);
                    }
                    if (!this.mTaskInfo.getTaskWasAborted()) break block23;
                    this.sendNotification(ROXTaskEvent.abort(this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel)), true);
                    this.mFailureException = new PlanExecutionException(new ROXMessage("pe.PLAN_ABORTED"));
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!this.mSentPreflightComplete) {
                        this.sendNotification(ROXTaskEvent.preflightComplete(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID()), true);
                    }
                    if (this.mTaskInfo.getTaskWasAborted()) {
                        this.sendNotification(ROXTaskEvent.abort(this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel)), true);
                        this.mFailureException = new PlanExecutionException(new ROXMessage("pe.PLAN_ABORTED"));
                    }
                    int numFailedHosts = this.mTaskInfo.getNumberFailedHosts();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("got " + numFailedHosts + " failed hosts", this);
                    }
                    if (this.mFailureException != null) {
                        PlanExecutionException eToSend = null;
                        eToSend = this.mFailureException instanceof PlanExecutionException ? (PlanExecutionException)this.mFailureException : new PlanExecutionException("pe.TASK_FAILED_WITH_EXCEPTION", new Object[]{this.mFailureException.getMessage(), this.mPlan.getTopLevelPlan().getFullName()});
                        this.sendNotification(ROXTaskEvent.failed(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel), eToSend), true);
                    } else if (numFailedHosts > 0) {
                        this.sendNotification(ROXTaskEvent.failed(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel), new PlanExecutionException("pe.TASK_FAILED_MSG", new Object[]{new Integer(numFailedHosts), this.mPlan.getTopLevelPlan().getFullName()})), true);
                    }
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Sending \"all over\" final completion event", this);
                    }
                    this.sendNotification(ROXTaskEvent.complete(this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mTaskInfo.getRunLevel())), true);
                    throw throwable;
                }
            }
            int numFailedHosts = this.mTaskInfo.getNumberFailedHosts();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("got " + numFailedHosts + " failed hosts", this);
            }
            if (this.mFailureException != null) {
                PlanExecutionException eToSend = null;
                eToSend = this.mFailureException instanceof PlanExecutionException ? (PlanExecutionException)this.mFailureException : new PlanExecutionException("pe.TASK_FAILED_WITH_EXCEPTION", new Object[]{this.mFailureException.getMessage(), this.mPlan.getTopLevelPlan().getFullName()});
                this.sendNotification(ROXTaskEvent.failed(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel), eToSend), true);
            } else if (numFailedHosts > 0) {
                this.sendNotification(ROXTaskEvent.failed(4, this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mCurrentRunLevel), new PlanExecutionException("pe.TASK_FAILED_MSG", new Object[]{new Integer(numFailedHosts), this.mPlan.getTopLevelPlan().getFullName()})), true);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Sending \"all over\" final completion event", this);
            }
            this.sendNotification(ROXTaskEvent.complete(this.mTaskInfo.getTaskID(), this.mPlan.getTopLevelPlan().getID(), TaskExecutor.isPreflightRunLevel(this.mTaskInfo.getRunLevel())), true);
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var7_10 = null;
            try {
                this.taskCompleted(this.mTaskInfo);
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14;
                v0 = var9_14 = null;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("RemovingPE for:" + this.mTaskInfo, this);
            }
            this.mPlanSubsystem.removePEFromList(this.mTaskInfo.getTaskID());
            TaskInfo.removeTaskFromCache(this.mTaskInfo);
            this.removeListeners();
            this.mTaskInfo.save();
            throw throwable;
        }
        try {
            this.taskCompleted(this.mTaskInfo);
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var9_13;
            v1 = var9_13 = null;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("RemovingPE for:" + this.mTaskInfo, this);
        }
        this.mPlanSubsystem.removePEFromList(this.mTaskInfo.getTaskID());
        TaskInfo.removeTaskFromCache(this.mTaskInfo);
        this.removeListeners();
        this.mTaskInfo.save();
        super.release();
    }

    protected void safeRun() throws Exception {
        LockContext lockContext = new LockContext(){

            public Object execute() throws Exception {
                boolean preflightPassed;
                long maxTimeLimitMillis;
                long startMillis;
                int[] subplanTargetsPassedCount;
                block9: {
                    block8: {
                        subplanTargetsPassedCount = null;
                        CompiledPlanExecutor.this.registerListeners();
                        CompiledPlanExecutor.this.sendNotification(ROXTaskEvent.start(CompiledPlanExecutor.this.mTaskInfo.getTaskID(), CompiledPlanExecutor.this.mPlan.getTopLevelPlan().getID(), CompiledPlanExecutor.this.mTaskInfo.getRoxUser(), TaskExecutor.isPreflightRunLevel(CompiledPlanExecutor.this.mTaskInfo.getRunLevel())), true);
                        try {
                            CompiledPlanExecutor.this.mTaskInfo.save();
                        }
                        catch (PersistenceManagerException pme) {
                            if (!Logger.isWarnEnabled(this)) break block8;
                            Logger.warn("Warning: ", pme, this);
                        }
                    }
                    CompiledPlanExecutor.this.taskStarted(CompiledPlanExecutor.this.mTaskInfo);
                    CompiledPlanExecutor.this.testFlow();
                    SessionManager localSessionManager = CompiledPlanExecutor.this.mApp.getUserDBSubsystem().getLocalSessionManager();
                    CompiledPlanExecutor.this.mTopLevelSessionCG = CompiledPlanExecutor.this.mCGMgr.getConfigGenerator().newSessionScope(localSessionManager, false);
                    CompiledPlanExecutor.this.mTopLevelPassSafeSessionCG = CompiledPlanExecutor.this.mCGMgr.getConfigGenerator().newSessionScope(localSessionManager, true);
                    CompiledPlanExecutor.this.mTopLevelCG = CompiledPlanExecutor.this.mTopLevelSessionCG.newCallScope(CompiledPlanExecutor.this.mPlan.getTopLevelPlan().getParams(), CompiledPlanExecutor.this.mTaskInfo.getPlanParamValues());
                    CompiledPlanExecutor.this.mTopLevelPasswdSafeCG = CompiledPlanExecutor.this.createPasswdSafeCG();
                    startMillis = CompiledPlanExecutor.this.mTaskInfo.getStartMillis();
                    maxTimeLimitMillis = CompiledPlanExecutor.this.mTaskInfo.getPlanTimeoutSecs() * 1000;
                    ContextThread heartT = CompiledPlanExecutor.this.mUserDB.getSessionTable().createThreadForCurrentSession(CompiledPlanExecutor.this.mHbtPinger);
                    heartT.start();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("PE starting a preflight for top level plan: " + CompiledPlanExecutor.this.mPlan.getTopLevelPlan().getFullName(), this);
                    }
                    subplanTargetsPassedCount = CompiledPlanExecutor.this.runPreflight(maxTimeLimitMillis);
                    preflightPassed = CompiledPlanExecutor.this.allSubplansHaveAtLeastOneSucessfulHost(subplanTargetsPassedCount);
                    CompiledPlanExecutor.this.mSentPreflightComplete = true;
                    CompiledPlanExecutor.this.sendNotification(ROXTaskEvent.preflightComplete(preflightPassed ? 2 : 4, CompiledPlanExecutor.this.mTaskInfo.getTaskID(), CompiledPlanExecutor.this.mPlan.getTopLevelPlan().getID()), true);
                    try {
                        CompiledPlanExecutor.this.mTaskInfo.save();
                    }
                    catch (PersistenceManagerException pme) {
                        if (!Logger.isWarnEnabled(this)) break block9;
                        Logger.warn("Warning: ", pme, this);
                    }
                }
                long timeLeft = CompiledPlanExecutor.this.getTimeLeftFromMax(maxTimeLimitMillis, startMillis, System.currentTimeMillis());
                if (timeLeft < 0L) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Plan ran out of time between preflight and actual", this);
                    }
                    CompiledPlanExecutor.this.sendNotification(ROXTaskEvent.timeout(CompiledPlanExecutor.this.mTaskInfo.getTaskID(), CompiledPlanExecutor.this.mTaskInfo.getPlanID(), true));
                    throw new PlanTimeoutException();
                }
                if (preflightPassed && CompiledPlanExecutor.this.mTaskInfo.getRunLevel().equals(RunLevel.ACTUAL)) {
                    CompiledPlanExecutor.this.testFlow();
                    CompiledPlanExecutor.this.mTaskInfo.prepareForActual();
                    subplanTargetsPassedCount = CompiledPlanExecutor.this.runActual(timeLeft);
                }
                return null;
            }
        };
        this.mPM.getSystemLockObject().readLock(ROXMessageManager.messageAsString("pe.RUN_PLAN_LOCK_MESSAGE", new Object[]{this.mPlan.getTopLevelPlan().getName()}), lockContext);
    }

    private ConfigGenerator createPasswdSafeCG() throws ConfigGenException {
        PromptParamList params = this.mPlan.getTopLevelPlan().getParams();
        VariableSettingsHolder values = this.mTaskInfo.getPlanParamValues();
        values = CompiledPlanExecutor.hidePasswordValues(params, values);
        return this.mTopLevelPassSafeSessionCG.newCallScope(params, values);
    }

    static VariableSettingsHolder hidePasswordValues(PromptParamList inParams, VariableSettingsSource inValues) {
        if (inValues != null) {
            VariableSettingsHolder values = new VariableSettingsHolder(inValues);
            String[] names = inParams.getVarNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    PromptParam prompt = inParams.getParam(names[i]);
                    if (prompt == null || !DisplayMode.PASSWORD.equals(prompt.getDisplayMode())) continue;
                    values.setVarValue(names[i], HIDE_PASSWORD_VALUE);
                }
            }
            return values;
        }
        return null;
    }

    private boolean allSubplansHaveAtLeastOneSucessfulHost(int[] inSubplanTargetsPassedCount) {
        for (int i = 0; i < inSubplanTargetsPassedCount.length; ++i) {
            if (inSubplanTargetsPassedCount[i] != 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] runPreflight(long inTimeLimit) throws InterruptedException, PlanTimeoutException, PlanExecutionException {
        this.mCurrentRunLevel = RunLevel.PREFLIGHT;
        try {
            int[] nArray = this.runSubplans(RunLevel.PREFLIGHT, inTimeLimit);
            return nArray;
        }
        finally {
            this.mTaskInfo.getVirtualAgentManager().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] runActual(long inTimeLimit) throws InterruptedException, PlanTimeoutException, PlanExecutionException {
        this.mCurrentRunLevel = RunLevel.ACTUAL;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("starting ACTUAL phase", this);
        }
        try {
            int[] nArray = this.runSubplans(RunLevel.ACTUAL, inTimeLimit);
            return nArray;
        }
        finally {
            this.mTaskInfo.getVirtualAgentManager().reset();
        }
    }

    private int[] runSubplans(RunLevel inRunLevel, long inTimeLimit) throws InterruptedException, PlanTimeoutException, PlanExecutionException {
        int[] subplanTargetsPassedCount = new int[this.mPlan.getNumSimpleSubplans()];
        SubplanInfo[] theSubplanInfos = this.mTaskInfo.getSubplanInfos();
        for (int i = 0; i < this.mPlan.getNumSimpleSubplans(); ++i) {
            if (inTimeLimit < 0L) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Ran out of time, timing out", this);
                }
                this.setRemainingSubplanHostsToFailure(i, this.mPlan.getNumSimpleSubplans());
                this.sendNotification(ROXTaskEvent.timeout(this.mTaskInfo.getTaskID(), this.mTaskInfo.getPlanID(), TaskExecutor.isPreflightRunLevel(inRunLevel)));
                throw new PlanTimeoutException();
            }
            SubplanInfo theInfo = theSubplanInfos[i];
            CompiledSimpleSubplan cSubplan = this.mPlan.getSimpleSubplan(i);
            long subplanStartTime = System.currentTimeMillis();
            subplanTargetsPassedCount[i] = this.runOneSubplan(inRunLevel, cSubplan, theInfo, inTimeLimit);
            inTimeLimit = this.getTimeLeftFromMax(inTimeLimit, subplanStartTime, System.currentTimeMillis());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("subplan " + i + " finished with nSuccessfulHosts: " + subplanTargetsPassedCount[i], this);
            }
            if (subplanTargetsPassedCount[i] != 0) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Subplan " + i + " failed on all hosts. Bailing out of exectution, all remaining hosts will be set to FAILURE", this);
            }
            this.setRemainingSubplanHostsToFailure(i + 1, this.mPlan.getNumSimpleSubplans());
            return subplanTargetsPassedCount;
        }
        return subplanTargetsPassedCount;
    }

    private int runOneSubplan(RunLevel inRunLevel, CompiledSimpleSubplan inSubplan, SubplanInfo inSubplanInfo, long inTimeLimit) throws InterruptedException, PlanTimeoutException, PlanExecutionException {
        Vector runners = new Vector();
        ContextThrottleMonitor monitor = new ContextThrottleMonitor();
        this.createVAinitPERsForHosts(inSubplanInfo, inSubplan, inRunLevel, runners, monitor);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("PE: Starting to wait for completion", this);
        }
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("PE: starting a timer for " + (double)inTimeLimit / 1000.0 + " secs", this);
            }
            Object[] stillRunning = monitor.monitor(inTimeLimit, 1000L, this.getPlanThrottle(inSubplan));
            monitor.join();
            int nTimeouts = stillRunning.length;
            if (nTimeouts > 0) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("PE: some PERs timed out: " + Util.getStringFromArray(stillRunning, ","), this);
                }
                this.sendNotification(ROXTaskEvent.timeout(this.mTaskInfo.getTaskID(), this.mTaskInfo.getPlanID(), TaskExecutor.isPreflightRunLevel(inRunLevel)));
                throw new PlanTimeoutException(nTimeouts);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("PE: finished waiting for completion", this);
            }
        }
        catch (InterruptedException ex) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("PE: aborted while waiting for all PERs to complete, manully forcing child timeout", ex, this);
            }
            monitor.monitor(0L, 0L, this.mTaskInfo.getPlanThrottle());
            monitor.join();
            this.testFlow();
        }
        return this.countSuccessfulPERs(runners);
    }

    private int countSuccessfulPERs(Vector inRunners) {
        int nErrors = 0;
        int nRunners = inRunners.size();
        int nSuccessfulPERs = 0;
        for (int i = 0; i < nRunners; ++i) {
            PlanExecutionRunner aRunner = (PlanExecutionRunner)inRunners.get(i);
            Throwable thisRunnerEx = aRunner.getTerminationException();
            if (thisRunnerEx != null && this.isPlanHaltingException(thisRunnerEx)) {
                ++nErrors;
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("PER for " + aRunner.getTargetID() + " had ex: " + thisRunnerEx.getClass().getName(), this);
                continue;
            }
            ++nSuccessfulPERs;
        }
        if (nErrors > 0 && Logger.isDebugEnabled(this)) {
            Logger.debug("PE finished with " + nErrors + " individual failed hosts", this);
        }
        return nSuccessfulPERs;
    }

    private boolean isPlanHaltingException(Throwable inEx) {
        return !(inEx instanceof PlanExecutionPreflightWarning);
    }

    private void sendNotification(ROXEvent inEvent, boolean inWait) {
        if (inWait) {
            this.mNotificationMgr.notifyAndWait(inEvent);
        } else {
            this.mNotificationMgr.notify(inEvent);
        }
    }

    private void sendNotification(ROXEvent inEvent) {
        this.sendNotification(inEvent, false);
    }

    private void setTargetsToStatus(TaskInfo ioTaskInfo, int inStatusToModify, int inFinalStatus) throws PersistenceManagerException, PlanExecutionException {
        TargetStatus[] subplanTargetsPassedCount = ioTaskInfo.getAllTargetsStatus();
        for (int i = 0; i < subplanTargetsPassedCount.length; ++i) {
            if (subplanTargetsPassedCount[i].getStatus() != inStatusToModify) continue;
            subplanTargetsPassedCount[i].setStatus(inFinalStatus);
            subplanTargetsPassedCount[i].save();
        }
    }

    private int getPlanThrottle(CompiledSimpleSubplan inPlan) {
        int throttle;
        boolean isParalell = inPlan.getSubplanExecutionMode().equals(ExecutionMode.PARALLEL);
        int n = throttle = isParalell ? this.mTaskInfo.getPlanThrottle() : 1;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Plan throttle for subplan " + inPlan.getName() + " is " + throttle, this);
        }
        return throttle;
    }

    protected void createVAinitPERsForHosts(SubplanInfo inSubplanInfo, CompiledSimpleSubplan inPlan, RunLevel inRunLevel, Vector ioRunners, ContextThrottleMonitor inMonitor) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating " + inSubplanInfo.getTargets().length + " PERs for plan " + inPlan.getName(), this);
        }
        Target[] allTargets = inSubplanInfo.getTargets();
        ExecStep stepToUse = inPlan.getInvokingStep();
        int permissionMap = (stepToUse == null ? 0 : stepToUse.getStepMap()) + 3;
        for (int i = 0; i < allTargets.length; ++i) {
            if (this.mTaskInfo.getTargetStatus(allTargets[i].getID()).getStatus() != 2) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("creating a PER for non-poisoned host " + allTargets[i].getPhysicalHost().getName(), this);
                }
                this.createPlanExecutionRunner(allTargets[i], inPlan, inRunLevel, ioRunners, permissionMap);
                continue;
            }
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("Ignoring host " + allTargets[i].getPhysicalHostID() + " b/c it's \"poisoned\"", this);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("got " + ioRunners.size() + " PERs, about to start them", this);
        }
        PlanExecutionRunner[] persToStart = ioRunners.toArray(new PlanExecutionRunner[0]);
        for (int i = 0; i < persToStart.length; ++i) {
            ContextThread t = this.mUserDB.getSessionTable().createThreadForCurrentSession(persToStart[i]);
            inMonitor.addThread(t);
        }
    }

    private void createPlanExecutionRunner(Target inTarget, CompiledSimpleSubplan inPlan, RunLevel inRunLevel, Vector inRunners, int inPermissionMap) {
        ExecutionState runnerState;
        block2: {
            runnerState = null;
            try {
                runnerState = new ExecutionState(this.mApp, inPlan, this.mTaskInfo, inRunLevel, this.mTopLevelSessionCG, this.mTopLevelPassSafeSessionCG);
                inPlan.setExecutionState(runnerState);
            }
            catch (UnsupportedSubsystemException ex) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error(ex.getROXMessage().toString(), ex, this);
            }
        }
        runnerState.setPlanRecorder(new BasicPlanRecorder(runnerState, this.mTaskInfo));
        BagID thisTaskIDBagID = new BagID(this.mTaskInfo.getTaskID().toString());
        VACreationData vaData = new VACreationData(inTarget, this.mTopLevelCG, this.mTopLevelPasswdSafeCG, this.mCGMgr, thisTaskIDBagID);
        PlanExecutionRunner runner = new PlanExecutionRunner(this, runnerState, vaData, inPermissionMap);
        runnerState.setPER(runner);
        inRunners.add(runner);
    }

    protected long getTimeLeftFromMax(long inMax, long inStart, long inEnd) {
        long duration = inEnd - inStart;
        long timeLeft = inMax - duration;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("duration: " + duration + " timeLeft: " + timeLeft, this);
        }
        return timeLeft;
    }

    private void setRemainingSubplanHostsToFailure(int inStartSubplan, int inTotalSubplans) throws PlanExecutionException {
        for (int i = inStartSubplan; i < inTotalSubplans; ++i) {
            SubplanInfo planInfo = this.mTaskInfo.getSubplanInfos()[i];
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("subplan " + planInfo.getSubplanName() + " was skipped, setting all of its hosts to FAILURE", this);
            }
            Target[] allTargets = planInfo.getTargets();
            for (int j = 0; j < allTargets.length; ++j) {
                this.mTaskInfo.setTargetStatus(allTargets[j].getID(), 2);
            }
        }
    }

    protected void registerListeners() {
        this.mTaskListener = new EventHandlerTaskListener(this.mTaskInfo, this.mPM);
        this.mNotificationMgr.addListener(this.mTaskListener, this.mTaskListener);
    }

    protected void removeListeners() {
        this.mNotificationMgr.removeListener(this.mTaskListener);
    }

    protected void taskStarted(TaskInfo inTaskInfo) {
    }

    protected void taskCompleted(TaskInfo inTaskInfo) throws PlanExecutionException {
        PETransaction[] tasks = inTaskInfo.getCleanupTasks();
        try {
            for (int i = 0; i < tasks.length; ++i) {
                PersistenceManager.getInstance().getTransactionManager().transact(tasks[i]);
            }
        }
        catch (Throwable t) {
            throw new PlanExecutionException(t);
        }
    }
}

