/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.CompiledPlanTraverser;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInvoker;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.util.collections.Compare;
import com.raplix.util.logger.Logger;
import java.util.Stack;
import java.util.Vector;

public class CompiledPlan
implements RPCSerializable {
    private Vector mSubplans;
    private ExecutionPlan mTopLevelPlan;

    public CompiledPlan(ExecutionPlan inTopLevelPlan) {
        this.mTopLevelPlan = inTopLevelPlan;
        this.mSubplans = new Vector();
    }

    private CompiledPlan() {
    }

    public int getNumSimpleSubplans() {
        return this.mSubplans.size();
    }

    public CompiledSimpleSubplan getSimpleSubplan(int inSubplanIndex) {
        return (CompiledSimpleSubplan)this.mSubplans.get(inSubplanIndex);
    }

    public ExecutionPlan getTopLevelPlan() {
        return this.mTopLevelPlan;
    }

    public void addSimpleSubplan(SubplanInvoker inPlanCaller, Stack inCallingChain) {
        CompiledSimpleSubplan theCSubplan = new CompiledSimpleSubplan(inPlanCaller, inCallingChain, this.mSubplans.size());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding SimplePlan: " + theCSubplan, this);
        }
        this.mSubplans.add(theCSubplan);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Current Compiled Plan is: " + this, this);
        }
    }

    public Object traversePlan(CompiledPlanTraverser inTraverser) throws PlanExecutionException {
        for (int subplanNum = 0; subplanNum < this.getNumSimpleSubplans(); ++subplanNum) {
            CompiledSimpleSubplan currSubplan = this.getSimpleSubplan(subplanNum);
            inTraverser.subplanEntered(currSubplan, this);
            ExecStep[] theSteps = currSubplan.getExecSteps();
            for (int stepNum = 0; stepNum < theSteps.length; ++stepNum) {
                ExecStep currStep = theSteps[stepNum];
                inTraverser.stepEncountered(stepNum, currStep, currSubplan, this);
            }
            inTraverser.subplanExited(currSubplan, this);
        }
        return inTraverser.getResults();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof CompiledPlan) {
            return this.equals((CompiledPlan)other);
        }
        return false;
    }

    public boolean equals(CompiledPlan inCPlan) {
        if (inCPlan == null) {
            return false;
        }
        if (this.getTopLevelPlan() == null ? inCPlan.getTopLevelPlan() != null : inCPlan.getTopLevelPlan() == null) {
            return false;
        }
        if (!this.getTopLevelPlan().equalsPlanData(inCPlan.getTopLevelPlan())) {
            return false;
        }
        if (inCPlan.getNumSimpleSubplans() != this.getNumSimpleSubplans()) {
            return false;
        }
        return Compare.isEqual(inCPlan.mSubplans, this.mSubplans);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Top Level Plan Name: ").append(this.mTopLevelPlan.getFullName()).append("Subplans: \n");
        for (int i = 0; i < this.mSubplans.size(); ++i) {
            CompiledSimpleSubplan theSubplan = (CompiledSimpleSubplan)this.mSubplans.get(i);
            buf.append(theSubplan.toString()).append("\n");
        }
        return buf.toString();
    }
}

