/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.ROXComponentControlServiceEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepAbortEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepCustomStepEvent;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.executor.EventSenderPlanRecorder;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.logger.Logger;

public class BasicPlanRecorder
extends EventSenderPlanRecorder {
    private TaskInfo mTaskInfo;
    private ExecutionState mExecState;

    public BasicPlanRecorder(ExecutionState inState, TaskInfo inTaskInfo) {
        super(inState.getNotificationManager());
        this.mExecState = inState;
        this.mTaskInfo = inTaskInfo;
    }

    public StepInfo findStep(int inStepMap, TargetID inTargetID, RunLevel inRunLevel) throws PlanExecutionException {
        return this.mTaskInfo.findStep(inStepMap, inTargetID, inRunLevel);
    }

    public StepInfo createStep(TargetID inTargetID, RunLevel inRunLevel, ExecStep inStep) throws PersistenceManagerException {
        return StepInfo.createStep(this.mTaskInfo, this.mExecState.getCompiledSubplan().getSubplanPlanID(), inStep, inTargetID, inRunLevel);
    }

    public StepInfo createStep(ExecStep inStep, StepInfo inParentInfo, boolean fMandatory) throws PersistenceManagerException {
        return StepInfo.createStep(inStep, inParentInfo, fMandatory);
    }

    public StepInfo createStep(ExecStep inStep, StepInfo inParentInfo, TargetID inTargetID) throws PersistenceManagerException {
        StepInfo si = StepInfo.createStep(inStep, inParentInfo, inTargetID);
        return si;
    }

    public StepInfo createStep(TaskInfo inTaskInfo, ExecutionPlanID inPlanID, int inStepType, int inMap, TargetID inTargetID, RunLevel inRunLevel) throws PersistenceManagerException {
        return StepInfo.createStep(inTaskInfo, inPlanID, inStepType, inMap, inTargetID, inRunLevel);
    }

    public StepInfo createStep(int inStepType, int inStepMap, StepInfo inParentStepInfo) throws PersistenceManagerException {
        return StepInfo.createStep(inStepType, inStepMap, inParentStepInfo);
    }

    public ROXStepStartEvent createSSE(StepInfo inStepInfo, int inSubplanIndex) {
        return ROXStepEvent.start(inStepInfo, inSubplanIndex);
    }

    public ROXStepCompleteEvent createSCE(StepInfo inStepInfo, int inSubplanIndex) {
        return ROXStepEvent.complete(inStepInfo, inSubplanIndex);
    }

    public ROXStepAbortEvent createSAE(StepInfo inStepInfo, int inSubplanIndex) {
        return ROXStepEvent.abort(inStepInfo, inSubplanIndex);
    }

    public ROXStepFailedEvent createSFE(StepInfo inStepInfo, int inSubplanIndex, int inFailureType, CommandException inEx) {
        return ROXStepEvent.failed(inFailureType, inStepInfo, inEx, inSubplanIndex);
    }

    public ROXTaskAbortEvent createTAE(TargetID inTargetID) {
        return ROXTaskEvent.abort(this.mExecState.getTaskID(), this.mExecState.getCompiledSubplan().getSubplanPlanID(), inTargetID, this.mExecState.getRunLevel().equals(RunLevel.PREFLIGHT));
    }

    public ROXComponentControlServiceEvent createCCSE(InstalledComponentID inInstalledCID, String inCallName, boolean fPreflight) {
        return ROXComponentControlServiceEvent.controlService(inInstalledCID, inCallName, fPreflight);
    }

    public ROXStepCustomStepEvent createCustomEvent(String inMessage, StepInfo inStepInfo, int inSubplanIndex) {
        return ROXStepEvent.customStep(inMessage, inStepInfo, inSubplanIndex);
    }

    public void setEventMessage(ROXEvent inEvent, String inMessage) {
        inEvent.setMessage(inMessage);
    }

    public void setTargetStatus(TargetID inTargetID, int inStatus, String inHostName) throws PlanExecutionException {
        if (inStatus == 2 || this.mTaskInfo.getRunLevel().equals(this.mExecState.getRunLevel())) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("setting host " + inHostName + " status to: " + inStatus, this);
            }
            this.mExecState.getTaskInfo().setTargetStatusKeepFailure(inTargetID, inStatus);
        }
    }

    public void sendEvent(ROXEvent inEvent) {
        this.sendEvent(inEvent, false);
    }

    public void sendEvent(ROXEvent inEvent, boolean inSynchronous) {
        if (inSynchronous) {
            this.mExecState.getNotificationManager().notifyAndWait(inEvent);
        } else {
            this.mExecState.getNotificationManager().notify(inEvent);
        }
    }

    public void saveExecNativeOutput(ExecNativeOutput inOutput) throws PersistenceManagerException {
        inOutput.save();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Saving output:" + inOutput, this);
        }
    }
}

