/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.AutoGeneratedPlanID;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanResultMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class AutoGeneratedPlan
extends PersistentObject
implements RPCSerializable,
HasObjectID {
    private ComponentID mComponentID;
    private ExecutionPlanID mPlanID;
    private String mProcedureName;
    private String mProcedureTarget;
    private NamedBlockType mProcedureType;
    private int mStepCount;
    private ExecutionPlan mPlan;
    private SummaryComponent mComponent;

    public AutoGeneratedPlan() {
    }

    public AutoGeneratedPlan(ComponentID inComponentID, ExecutionPlanID inPlanID, String inProcedureName, String inProcedureTarget, NamedBlockType inProcedureType, int inStepCount) {
        this.mComponentID = inComponentID;
        this.mPlanID = inPlanID;
        this.mProcedureName = inProcedureName;
        this.mProcedureTarget = inProcedureTarget;
        this.mProcedureType = inProcedureType;
        this.mStepCount = inStepCount;
    }

    public void setComponentID(ComponentID inComponentID) {
        this.mComponentID = inComponentID;
    }

    public ComponentID getComponentID() {
        return this.mComponentID;
    }

    public void setPlanID(ExecutionPlanID inPlanID) {
        this.mPlanID = inPlanID;
    }

    public ExecutionPlanID getPlanID() {
        return this.mPlanID;
    }

    public void setProcedureType(NamedBlockType inProcedureType) {
        this.mProcedureType = inProcedureType;
    }

    public NamedBlockType getProcedureType() {
        return this.mProcedureType;
    }

    private void setProcedureTypeAsString(String inProcedureType) {
        this.mProcedureType = NamedBlockType.FACTORY.get(inProcedureType);
    }

    private String getProcedureTypeAsString() {
        return this.mProcedureType.toString();
    }

    public void setProcedureName(String inProcedureName) {
        this.mProcedureName = inProcedureName;
    }

    public String getProcedureName() {
        return this.mProcedureName;
    }

    public void setProcedureTarget(String inProcedureTarget) {
        this.mProcedureTarget = inProcedureTarget;
    }

    public String getProcedureTarget() {
        return this.mProcedureTarget;
    }

    public void setSetCount(int inStepCount) {
        this.mStepCount = inStepCount;
    }

    public int getStepCount() {
        return this.mStepCount;
    }

    private void setPlan(ExecutionPlan inPlan) {
        this.mPlan = inPlan;
    }

    private void setComponent(SummaryComponent inComp) {
        this.mComponent = inComp;
    }

    public ExecutionPlan getPlan() {
        return this.mPlan;
    }

    public SummaryComponent getComponent() {
        return this.mComponent;
    }

    public AutoGeneratedPlanID getAutoGeneratedPlanID() {
        return (AutoGeneratedPlanID)this.getObjectID();
    }

    public AutoGeneratedPlanID getID() {
        return this.getAutoGeneratedPlanID();
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("ComponentID|PlanID|Name|Target|Type|StepCount\n");
        output.append(this.mComponentID).append("|").append(this.mPlanID).append("|").append(this.mProcedureName).append("|").append(this.mProcedureTarget).append("|");
        output.append(this.mProcedureType).append("|").append(this.mStepCount);
        return output.toString();
    }

    public static AutoGeneratedPlan getAutoGeneratedPlan(ComponentID inComponentID, String inProcedureName, String inProcedureTarget, NamedBlockType inProcedureType) throws PersistenceManagerException {
        AutoGeneratedPlanRetriever retriever = new AutoGeneratedPlanRetriever(inComponentID, inProcedureName, inProcedureTarget, inProcedureType);
        return retriever.getResult();
    }

    public static ExecutionPlan getMostRecentPlanForComponent(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) throws PersistenceManagerException {
        AutoGeneratedPlanRetriever retriever = new AutoGeneratedPlanRetriever(inComponentID, inProcedureName, null, inProcedureType, true);
        AutoGeneratedPlan result = retriever.getResult();
        return null == result ? null : retriever.getResult().getPlan();
    }

    private static final class AutoGeneratedPlanResultSetProcessor
    extends ResultProcessor {
        private AutoGeneratedPlanTable mAGPlanTable;
        private ExecutionPlanResultMap mPlanMap;
        private ComponentImplTable mCompTable;

        public AutoGeneratedPlanResultSetProcessor(AutoGeneratedPlanTable inAutoGeneratedPlanTable, ExecutionPlanImplTable inPlanTable, ComponentImplTable inCompTable) {
            this.mAGPlanTable = inAutoGeneratedPlanTable;
            this.mPlanMap = new ExecutionPlanResultMap(inPlanTable);
            this.mCompTable = inCompTable;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            AutoGeneratedPlan theAGPlan = this.mAGPlanTable.retrieveObject(inResultSet);
            this.mPlanMap.addResult(inResultSet);
            theAGPlan.setComponent(SummaryComponent.createFromResultSet(this.mCompTable, inResultSet));
            return theAGPlan;
        }

        public Vector getResults() throws PersistenceManagerException {
            this.mPlanMap.mapResults();
            this.mapResults();
            return this.mResults;
        }

        protected Object mapObject(Object obj) {
            AutoGeneratedPlan agp = (AutoGeneratedPlan)obj;
            agp.setPlan(this.mPlanMap.get(agp.getPlanID()));
            return agp;
        }
    }

    private static class AutoGeneratedPlanRetriever
    extends QueryBuilder {
        private AutoGeneratedPlan mResult = null;

        protected AutoGeneratedPlanRetriever(ComponentID inComponentID, String inProcedureName, String inProcedureTarget, NamedBlockType inProcedureType) throws PersistenceManagerException {
            this(inComponentID, inProcedureName, inProcedureTarget, inProcedureType, false);
        }

        protected AutoGeneratedPlanRetriever(ComponentID inComponentID, String inProcedureName, String inProcedureTarget, NamedBlockType inProcedureType, boolean inLookingForSimilarPlan) throws PersistenceManagerException {
            this.mResult = this.getAutoGeneratedPlan(inComponentID, inProcedureName, inProcedureTarget, inProcedureType, inLookingForSimilarPlan);
        }

        protected AutoGeneratedPlan getAutoGeneratedPlan(ComponentID inComponentID, String inProcedureName, String inProcedureTarget, NamedBlockType inProcedureType, boolean inLookingForSimilarPlan) throws PersistenceManagerException {
            AutoGeneratedPlanTable agPlanTable = new AutoGeneratedPlanTable("agpt");
            ExecutionPlanImplTable planTable = new ExecutionPlanImplTable("ept");
            ComponentImplTable compTable = new ComponentImplTable("pct");
            SelectList selectList = AutoGeneratedPlanRetriever.sList(agPlanTable.allColumns(), planTable.allColumns(), compTable.allColumns());
            TableList tableList = AutoGeneratedPlanRetriever.tList(agPlanTable, planTable, compTable);
            AndExp where = AutoGeneratedPlanRetriever.and();
            if (inLookingForSimilarPlan) {
                ComponentImplTable innerCompTable = new ComponentImplTable("ipct");
                where.add(AutoGeneratedPlanRetriever.equals((ColumnNode)compTable.RootID, AutoGeneratedPlanRetriever.select(AutoGeneratedPlanRetriever.sList(innerCompTable.RootID), AutoGeneratedPlanRetriever.tList(innerCompTable), AutoGeneratedPlanRetriever.where(AutoGeneratedPlanRetriever.equals(innerCompTable.ID, inComponentID)))));
            } else {
                where.add(AutoGeneratedPlanRetriever.equals(agPlanTable.ComponentID, inComponentID));
            }
            where.add(AutoGeneratedPlanRetriever.equals((ColumnNode)agPlanTable.ComponentID, compTable.ID));
            where.add(AutoGeneratedPlanRetriever.equals((ColumnNode)agPlanTable.PlanID, planTable.ID));
            if (null != inProcedureName) {
                where.add(AutoGeneratedPlanRetriever.equals(agPlanTable.ProcedureName, inProcedureName));
            }
            if (null != inProcedureTarget) {
                where.add(AutoGeneratedPlanRetriever.equals(agPlanTable.ProcedureTarget, inProcedureTarget));
            }
            if (null != inProcedureType) {
                where.add(AutoGeneratedPlanRetriever.equals(agPlanTable.ProcedureTypeAsString, inProcedureType.toString()));
            }
            AutoGeneratedPlanResultSetProcessor processor = new AutoGeneratedPlanResultSetProcessor(agPlanTable, planTable, compTable);
            OrderByList orderList = AutoGeneratedPlanRetriever.oList(AutoGeneratedPlanRetriever.orderByDesc(planTable.Version));
            AutoGeneratedPlanRetriever.execute(AutoGeneratedPlanRetriever.limit(AutoGeneratedPlanRetriever.select(selectList, tableList, AutoGeneratedPlanRetriever.where(where), orderList), 1, 0), processor);
            Vector results = processor.getResults();
            if (results.isEmpty()) {
                return null;
            }
            return (AutoGeneratedPlan)results.get(0);
        }

        protected AutoGeneratedPlan getResult() {
            return this.mResult;
        }
    }
}

