/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.Messages;
import com.raplix.rolloutexpress.event.rule.NoSuchRuleException;
import com.raplix.rolloutexpress.event.rule.PersistentRuleMetaData;
import com.raplix.rolloutexpress.event.rule.PersistentRuleMetaDataTable;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataListener;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PMSQLException;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotRetrievedQueryException;
import java.util.HashMap;

public class RuleMetaDataManagerImpl
implements RuleMetaDataManager,
Messages {
    private static final String MSG_RETRIEVE_RULE_ERROR = "event.rule.RETRIEVE_RULE_ERROR";
    private static final String MSG_SAVE_RULE_ERROR = "event.rule.SAVE_RULE_ERROR";
    private static final String MSG_DELETE_RULE_ERROR = "event.rule.DELETE_RULE_ERROR";
    private static final String MSG_RETRIEVE_RULES_ERROR = "event.rule.RETRIEVE_RULES_ERROR";
    private RuleMetaDataListener mListener;
    private static final HashMap MESSAGE_MAP = RuleMetaDataManagerImpl.initMessageMap();

    public RuleMetaDataManagerImpl(RPCManager rpc, RuleMetaDataListener listener) throws RPCException {
        rpc.registerService(RuleMetaDataManager.class, this);
        this.setListener(listener);
    }

    private RuleMetaDataListener getListener() {
        return this.mListener;
    }

    private void setListener(RuleMetaDataListener listener) {
        this.mListener = listener;
    }

    public RuleMetaData retrieveRule(RuleID ruleID) throws RuleException {
        if (null == ruleID) {
            throw new NoSuchRuleException(ruleID);
        }
        PersistentRuleMetaData rule = new PersistentRuleMetaData(ruleID);
        try {
            rule.retrieve();
        }
        catch (ObjectNotRetrievedQueryException e) {
            throw new NoSuchRuleException(ruleID);
        }
        catch (PersistenceManagerException e) {
            throw new RuleException(MSG_RETRIEVE_RULE_ERROR, (Throwable)e);
        }
        return rule.toRPCSerializable();
    }

    public RuleMetaData retrieveRuleByName(String ruleName) throws RuleException {
        if (null == ruleName) {
            throw new NoSuchRuleException(ruleName);
        }
        PersistentRuleMetaDataTable t = PersistentRuleMetaDataTable.DEFAULT;
        Select query = t.select(PersistentRuleMetaDataTable.where(PersistentRuleMetaDataTable.equals(t.Name, ruleName)));
        RuleMetaData[] results = this.executeQuery(query);
        if (0 == results.length) {
            throw new NoSuchRuleException(ruleName);
        }
        return results[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleID saveRule(RuleMetaData rule) throws RuleException {
        rule.validate();
        PersistentRuleMetaData pRule = new PersistentRuleMetaData(rule);
        boolean isNew = rule.getRuleID() == null;
        try {
            RuleMetaDataManagerImpl ruleMetaDataManagerImpl = this;
            synchronized (ruleMetaDataManagerImpl) {
                pRule.save();
                if (isNew) {
                    this.getListener().ruleAdded(rule);
                } else {
                    this.getListener().ruleModified(rule);
                }
            }
        }
        catch (PMSQLException e) {
            ROXMessage msg = (ROXMessage)MESSAGE_MAP.get(e.getMessage());
            if (msg != null) {
                throw new RuleException(msg, (Throwable)e, 0);
            }
            throw new RuleException(MSG_SAVE_RULE_ERROR, (Throwable)e);
        }
        catch (PersistenceManagerException e) {
            throw new RuleException(MSG_SAVE_RULE_ERROR, (Throwable)e);
        }
        return pRule.getRuleID();
    }

    private static HashMap initMessageMap() {
        HashMap<String, ROXMessage> map = new HashMap<String, ROXMessage>();
        map.put("ERROR:  Cannot insert a duplicate key into unique index rox_rule_c_name_key\n", MSG_UNIQUE_RULENAME_ERROR);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRule(RuleID ruleID) throws RuleException {
        PersistentRuleMetaData rule = new PersistentRuleMetaData(this.retrieveRule(ruleID));
        try {
            RuleMetaDataManagerImpl ruleMetaDataManagerImpl = this;
            synchronized (ruleMetaDataManagerImpl) {
                rule.delete();
                this.getListener().ruleRemoved(ruleID);
            }
        }
        catch (PersistenceManagerException e) {
            throw new RuleException(MSG_DELETE_RULE_ERROR, (Throwable)e);
        }
    }

    public RuleMetaData[] getAllRules() throws RuleException {
        PersistentRuleMetaDataTable t = PersistentRuleMetaDataTable.DEFAULT;
        return this.executeQuery(t.select((SelectList)t.allColumns(), null, PersistentRuleMetaDataTable.dictOrderAsc(t.Name)));
    }

    private RuleMetaData[] executeQuery(Select query) throws RuleException {
        try {
            PersistentRuleMetaDataTable t = PersistentRuleMetaDataTable.DEFAULT;
            PersistentBean[] pResults = PersistentRuleMetaDataTable.executeMultiResult(query, t);
            int size = pResults.length;
            RuleMetaData[] results = new RuleMetaData[size];
            for (int i = 0; i < size; ++i) {
                PersistentRuleMetaData rule = (PersistentRuleMetaData)pResults[i];
                rule.retrieveCriteriaHosts();
                results[i] = rule.toRPCSerializable();
            }
            return results;
        }
        catch (PersistenceManagerException e) {
            throw new RuleException(MSG_RETRIEVE_RULES_ERROR, (Throwable)e);
        }
    }
}

