/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.MetaDataBase;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.util.Validate;

public class RuleMetaData
extends MetaDataBase {
    private static final String MSG_INVALID_NAME = "event.rule.INVALID_NAME";
    private static final String MSG_INVALID_DESCRIPTION = "event.rule.INVALID_DESCRIPTION";
    private RuleID mRuleID;
    private int mUpdateCount;
    private boolean mIsActive;
    private String mName;
    private String mDescription;
    private static final CriteriaMetaData[] EMPTY_CRITERIA = new CriteriaMetaData[0];
    private CriteriaMetaData[] mCriteria;
    private static final ActionMetaData[] EMPTY_ACTIONS = new ActionMetaData[0];
    private ActionMetaData[] mActions;

    public RuleID getRuleID() {
        return this.mRuleID;
    }

    public void setRuleID(RuleID ruleID) {
        this.mRuleID = ruleID;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.mUpdateCount = updateCount;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public CriteriaMetaData[] getCriteria() {
        if (this.mCriteria == null) {
            return EMPTY_CRITERIA;
        }
        return this.mCriteria;
    }

    public void setCriteria(CriteriaMetaData[] criteria) {
        this.mCriteria = criteria;
    }

    public ActionMetaData[] getActions() {
        if (this.mActions == null) {
            return EMPTY_ACTIONS;
        }
        return this.mActions;
    }

    public void setActions(ActionMetaData[] actions) {
        this.mActions = actions;
    }

    public void validate() throws RuleException {
        if (!Validate.isValidObjectName(this.getName(), 32)) {
            throw new RuleException(MSG_INVALID_NAME);
        }
        String desc = this.getDescription();
        if (desc != null && !Validate.isValidObjectDescription(desc)) {
            throw new RuleException(MSG_INVALID_DESCRIPTION);
        }
        CriteriaMetaData[] criteria = this.getCriteria();
        for (int i = 0; i < criteria.length; ++i) {
            criteria[i].validate();
        }
        ActionMetaData[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].validate();
        }
    }

    public boolean equals(Object other, boolean ignoreID) {
        if (other == null || !(other instanceof RuleMetaData)) {
            return false;
        }
        RuleMetaData otherRule = (RuleMetaData)other;
        return (ignoreID || this.equals((Object)this.getRuleID(), otherRule.getRuleID()) && this.getUpdateCount() == otherRule.getUpdateCount()) && this.equals((Object)this.getName(), otherRule.getName()) && this.equals((Object)this.getDescription(), otherRule.getDescription()) && this.isActive() == otherRule.isActive() && this.equals(this.getActions(), otherRule.getActions(), ignoreID) && this.equals(this.getCriteria(), otherRule.getCriteria(), ignoreID);
    }

    public int hashCode() {
        return this.hashCode(this.getRuleID()) + this.hashCode(this.getName()) + this.hashCode(this.getDescription()) + this.hashCode(this.isActive()) + this.hashCode(this.getActions()) + this.hashCode(this.getCriteria());
    }

    public void toStringBuffer(StringBuffer buf, String prefix) {
        buf.append(prefix);
        buf.append("RuleMetaData{\n");
        String newPrefix = prefix + "  ";
        buf.append(newPrefix);
        buf.append("ruleID=");
        buf.append(this.getRuleID());
        buf.append("\n");
        buf.append(newPrefix);
        buf.append("name=");
        buf.append(this.getName());
        buf.append("\n");
        buf.append(newPrefix);
        buf.append("description=");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append(newPrefix);
        buf.append("isActive=");
        buf.append(this.isActive());
        buf.append("\n");
        this.toStringBuffer(this.getActions(), "actions=", buf, newPrefix);
        this.toStringBuffer(this.getCriteria(), "criteria=", buf, newPrefix);
        buf.append(prefix);
        buf.append("}\n");
    }
}

