/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.rule.ActionFactory;
import com.raplix.rolloutexpress.event.rule.CriteriaFactory;
import com.raplix.rolloutexpress.event.rule.CriteriaFactoryImpl;
import com.raplix.rolloutexpress.event.rule.Rule;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataListener;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManagerImpl;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.util.logger.Logger;
import java.util.HashMap;

public class RuleManager {
    private HashMap mRules = new HashMap();
    private static final String MSG_DUPLICATE_RULE = "event.rule.manager.DUPLICATE_RULE";
    private static final String MSG_UNKNOWN_RULE_UPDATE = "event.rule.manager.UNKNOWN_RULE_UPDATE";
    private static final String MSG_UNKNOWN_RULE_REMOVAL = "event.rule.manager.UNKNOWN_RULE_REMOVAL";
    private CriteriaFactory mCriteriaFactory;
    private ActionFactory mActionFactory;
    private NotificationManager mNotificationManager;

    public RuleManager(NotificationManager nm, RPCManager rpc, ActionFactory actionFactory) throws RPCException, RuleException {
        this.setNotificationManager(nm);
        this.setActionFactory(actionFactory);
        this.setCriteriaFactory(new CriteriaFactoryImpl());
        RuleMetaDataManagerImpl ruleManager = new RuleMetaDataManagerImpl(rpc, new Listener());
        this.initRules(ruleManager.getAllRules());
    }

    private CriteriaFactory getCriteriaFactory() {
        return this.mCriteriaFactory;
    }

    private void setCriteriaFactory(CriteriaFactory criteriaFactory) {
        this.mCriteriaFactory = criteriaFactory;
    }

    private ActionFactory getActionFactory() {
        return this.mActionFactory;
    }

    private void setActionFactory(ActionFactory actionFactory) {
        this.mActionFactory = actionFactory;
    }

    private void initRules(RuleMetaData[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i].getRuleID(), rules[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRule(RuleID ruleID, RuleMetaData ruleData) {
        Rule rule = this.newRule(ruleData);
        HashMap hashMap = this.mRules;
        synchronized (hashMap) {
            if (this.mRules.put(ruleID, rule) != null && Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString(MSG_DUPLICATE_RULE), this);
            }
            this.activateRule(rule);
        }
    }

    private Rule newRule(RuleMetaData ruleData) {
        return new Rule(this.getActionFactory(), this.getCriteriaFactory(), ruleData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRule(RuleID ruleID, RuleMetaData ruleData) {
        Rule newRule = this.newRule(ruleData);
        HashMap hashMap = this.mRules;
        synchronized (hashMap) {
            Rule oldRule = this.mRules.put(ruleID, newRule);
            if (oldRule != null) {
                this.reactivateRule(oldRule, newRule);
            } else {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(ROXMessageManager.messageAsString(MSG_UNKNOWN_RULE_UPDATE), this);
                }
                this.activateRule(newRule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRule(RuleID ruleID) {
        HashMap hashMap = this.mRules;
        synchronized (hashMap) {
            Rule rule = (Rule)this.mRules.remove(ruleID);
            if (rule != null) {
                this.deactivateRule(rule);
            } else if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString(MSG_UNKNOWN_RULE_REMOVAL), this);
            }
        }
    }

    private NotificationManager getNotificationManager() {
        return this.mNotificationManager;
    }

    private void setNotificationManager(NotificationManager notificationManager) {
        this.mNotificationManager = notificationManager;
    }

    private void activateRule(Rule rule) {
        this.getNotificationManager().addListener(rule, rule);
    }

    private void reactivateRule(Rule oldRule, Rule newRule) {
        this.getNotificationManager().replaceListener(oldRule, newRule, newRule);
    }

    private void deactivateRule(Rule rule) {
        this.getNotificationManager().removeListener(rule);
    }

    private class Listener
    implements RuleMetaDataListener {
        private Listener() {
        }

        public void ruleAdded(RuleMetaData rule) {
            RuleManager.this.addRule(rule.getRuleID(), rule);
        }

        public void ruleModified(RuleMetaData rule) {
            RuleManager.this.updateRule(rule.getRuleID(), rule);
        }

        public void ruleRemoved(RuleID ruleID) {
            RuleManager.this.removeRule(ruleID);
        }
    }
}

