/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventListener;
import com.raplix.rolloutexpress.event.ROXNotificationRule;
import com.raplix.rolloutexpress.event.rule.Action;
import com.raplix.rolloutexpress.event.rule.ActionFactory;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.Criteria;
import com.raplix.rolloutexpress.event.rule.CriteriaFactory;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;

class Rule
implements ROXNotificationRule,
ROXEventListener {
    private boolean mIsActive;
    private RuleMetaData mMetaData;
    private Action[] mActions;
    private Criteria[] mCriteria;

    public Rule(ActionFactory actionFactory, CriteriaFactory criteriaFactory, RuleMetaData metaData) {
        this.setIsActive(metaData.isActive());
        this.setMetaData(metaData);
        this.setActions(this.toAction(metaData.getActions(), actionFactory));
        this.setCriteria(this.toCriteria(metaData.getCriteria(), criteriaFactory));
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    private void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    private RuleMetaData getMetaData() {
        return this.mMetaData;
    }

    private void setMetaData(RuleMetaData metaData) {
        this.mMetaData = metaData;
    }

    private Action[] toAction(ActionMetaData[] metaData, ActionFactory actionFactory) {
        Action[] actions = new Action[metaData.length];
        for (int i = 0; i < metaData.length; ++i) {
            actions[i] = actionFactory.newAction(metaData[i], this.getMetaData());
        }
        return actions;
    }

    public Action[] getActions() {
        return this.mActions;
    }

    private void setActions(Action[] actions) {
        this.mActions = actions;
    }

    private Criteria[] toCriteria(CriteriaMetaData[] metaData, CriteriaFactory criteriaFactory) {
        Criteria[] criteria = new Criteria[metaData.length];
        for (int i = 0; i < metaData.length; ++i) {
            criteria[i] = criteriaFactory.newCriteria(metaData[i]);
        }
        return criteria;
    }

    public Criteria[] getCriteria() {
        return this.mCriteria;
    }

    private void setCriteria(Criteria[] criteria) {
        this.mCriteria = criteria;
    }

    public boolean isInteresting(ROXEvent event) {
        if (!this.isActive()) {
            return false;
        }
        Criteria[] criteria = this.getCriteria();
        for (int i = 0; i < criteria.length; ++i) {
            if (criteria[i].isInteresting(event)) continue;
            return false;
        }
        return true;
    }

    public void eventHappened(ROXEvent event) {
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].eventHappened(event);
        }
    }
}

