/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaToHostLink;
import com.raplix.rolloutexpress.event.rule.CriteriaToHostLinkTable;
import com.raplix.rolloutexpress.event.rule.PersistentActionMetaData;
import com.raplix.rolloutexpress.event.rule.PersistentCriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class PersistentRuleMetaData
extends PersistentObject {
    private RuleMetaData mHolder;

    public PersistentRuleMetaData() {
        this(null, null);
    }

    public PersistentRuleMetaData(RuleID ruleID) {
        this(ruleID, null);
    }

    public PersistentRuleMetaData(RuleMetaData holder) {
        this(holder.getRuleID(), holder);
    }

    private PersistentRuleMetaData(RuleID ruleID, RuleMetaData holder) {
        if (ruleID != null) {
            this.setPersistent(true);
            this.setRuleID(ruleID);
        }
        this.mHolder = holder;
    }

    private RuleMetaData getHolder() {
        if (this.mHolder == null) {
            this.mHolder = new RuleMetaData();
        }
        return this.mHolder;
    }

    private void setHolder(RuleMetaData holder) {
        this.mHolder = holder;
    }

    public void setObjectID(ObjectID id) {
        this.setRuleID((RuleID)id);
    }

    public RuleID getRuleID() {
        return (RuleID)this.getObjectID();
    }

    public void setRuleID(RuleID ruleID) {
        super.setObjectID(ruleID);
        this.getHolder().setRuleID(ruleID);
    }

    public int getUpdateCount() {
        return this.getHolder().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getHolder().setUpdateCount(updateCount);
    }

    public boolean getIsActive() {
        return this.getHolder().isActive();
    }

    public void setIsActive(boolean isActive) {
        this.getHolder().setIsActive(isActive);
    }

    public String getName() {
        return this.getHolder().getName();
    }

    public void setName(String name) {
        this.getHolder().setName(name);
    }

    public String getDescription() {
        return this.getHolder().getDescription();
    }

    public void setDescription(String description) {
        this.getHolder().setDescription(description);
    }

    public PersistentCriteriaMetaData[] getCriteria() {
        return this.toPersistent(this.getHolder().getCriteria());
    }

    public void setCriteria(PersistentCriteriaMetaData[] criteria) {
        this.getHolder().setCriteria(this.toRPCSerializable(criteria));
    }

    public PersistentActionMetaData[] getActions() {
        return this.toPersistent(this.getHolder().getActions());
    }

    public void setActions(PersistentActionMetaData[] actions) {
        this.getHolder().setActions(this.toRPCSerializable(actions));
    }

    private PersistentCriteriaMetaData[] toPersistent(CriteriaMetaData[] arr) {
        if (arr == null) {
            return null;
        }
        PersistentCriteriaMetaData[] result = new PersistentCriteriaMetaData[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = new PersistentCriteriaMetaData(arr[i]);
        }
        return result;
    }

    private CriteriaMetaData[] toRPCSerializable(PersistentCriteriaMetaData[] arr) {
        if (arr == null) {
            return null;
        }
        CriteriaMetaData[] result = new CriteriaMetaData[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i].toRPCSerializable();
        }
        return result;
    }

    private PersistentActionMetaData[] toPersistent(ActionMetaData[] arr) {
        if (arr == null) {
            return null;
        }
        PersistentActionMetaData[] result = new PersistentActionMetaData[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = new PersistentActionMetaData(arr[i]);
        }
        return result;
    }

    private ActionMetaData[] toRPCSerializable(PersistentActionMetaData[] arr) {
        if (arr == null) {
            return null;
        }
        ActionMetaData[] result = new ActionMetaData[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i].toRPCSerializable();
        }
        return result;
    }

    public RuleMetaData toRPCSerializable() {
        return this.getHolder();
    }

    public void save() throws PersistenceManagerException {
        PersistentRuleMetaData.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                if (PersistentRuleMetaData.this.getRuleID() != null) {
                    PersistentRuleMetaData oldRule = new PersistentRuleMetaData(PersistentRuleMetaData.this.getRuleID());
                    oldRule.retrieve();
                    oldRule.deleteCriteriaHosts();
                }
                PersistentRuleMetaData.super.save();
                CriteriaToHostLinkTable lt = CriteriaToHostLinkTable.DEFAULT;
                PersistentCriteriaMetaData[] criteria = PersistentRuleMetaData.this.getCriteria();
                for (int i = 0; i < criteria.length; ++i) {
                    lt.resetLinks(criteria[i].getCriteriaID(), criteria[i].getHostIDs(), criteria[i].getCriteriaID() != null);
                }
                return null;
            }
        });
    }

    public void retrieve() throws PersistenceManagerException {
        super.retrieve();
        this.retrieveCriteriaHosts();
    }

    public void delete() throws PersistenceManagerException {
        PersistentRuleMetaData.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                PersistentRuleMetaData.this.deleteCriteriaHosts();
                PersistentRuleMetaData.super.delete();
                return null;
            }
        });
    }

    void retrieveCriteriaHosts() throws PersistenceManagerException {
        CriteriaToHostLinkTable lt = CriteriaToHostLinkTable.DEFAULT;
        PersistentCriteriaMetaData[] criteria = this.getCriteria();
        for (int i = 0; i < criteria.length; ++i) {
            CriteriaToHostLink[] cthla = (CriteriaToHostLink[])lt.getByParentID(criteria[i].getCriteriaID());
            HostID[] hosts = new HostID[cthla.length];
            for (int j = 0; j < cthla.length; ++j) {
                hosts[j] = cthla[j].getChildID();
            }
            criteria[i].setHosts(hosts);
        }
    }

    void deleteCriteriaHosts() throws PersistenceManagerException {
        CriteriaToHostLinkTable lt = CriteriaToHostLinkTable.DEFAULT;
        PersistentCriteriaMetaData[] criteria = this.getCriteria();
        for (int i = 0; i < criteria.length; ++i) {
            lt.removeByParentID(criteria[i].getCriteriaID());
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        public ObjectID newInstance(String id) {
            return new RuleID(id);
        }

        public RuleID generateRuleID() {
            return (RuleID)this.generateObjectID();
        }
    }
}

