/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.CriteriaID;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;

public class PersistentCriteriaMetaData
extends PersistentObject
implements UsingObject,
Messages {
    private CriteriaMetaData mHolder;

    public PersistentCriteriaMetaData() {
    }

    public PersistentCriteriaMetaData(CriteriaMetaData holder) {
        CriteriaID criteriaID = holder.getCriteriaID();
        if (criteriaID != null) {
            this.setPersistent(true);
            this.setCriteriaID(criteriaID);
        }
        this.mHolder = holder;
    }

    private CriteriaMetaData getHolder() {
        if (this.mHolder == null) {
            this.mHolder = new CriteriaMetaData();
        }
        return this.mHolder;
    }

    private void setHolder(CriteriaMetaData holder) {
        this.mHolder = holder;
    }

    public String getName() {
        return PersistenceManager.getObjectName(this.getClass()).getMessageString();
    }

    public String getDescription() {
        return MSG_CRITERIA_DESC.getMessageString();
    }

    public void setObjectID(ObjectID id) {
        this.setCriteriaID((CriteriaID)id);
    }

    public CriteriaID getCriteriaID() {
        return (CriteriaID)this.getObjectID();
    }

    public void setCriteriaID(CriteriaID criteriaID) {
        super.setObjectID(criteriaID);
        this.getHolder().setCriteriaID(criteriaID);
    }

    public String[] getEventTypes() {
        return this.getHolder().getEventTypes();
    }

    public void setEventTypes(String[] eventTypes) {
        this.getHolder().setEventTypes(eventTypes);
    }

    public int getTaskEventType() {
        return this.getHolder().getTaskEventType();
    }

    public void setTaskEventType(int taskEventType) {
        this.getHolder().setTaskEventType(taskEventType);
    }

    public String getMessagePattern() {
        return this.getHolder().getMessagePattern();
    }

    public void setMessagePattern(String messagePattern) {
        this.getHolder().setMessagePattern(messagePattern);
    }

    public HostID[] getHostIDs() {
        return this.getHolder().getHosts();
    }

    public String[] getHosts() {
        return this.toString(this.getHolder().getHosts());
    }

    public void setHosts(HostID[] hosts) {
        this.getHolder().setHosts(hosts);
    }

    public void setHosts(String[] hosts) {
        this.getHolder().setHosts(this.toHostID(hosts));
    }

    public String getHostSet() {
        return this.toString(this.getHolder().getHostSet());
    }

    public void setHostSet(String hostSet) {
        this.getHolder().setHostSet(this.toHostSetID(hostSet));
    }

    public int getHostStatus() {
        return this.getHolder().getHostStatus();
    }

    public void setHostStatus(int hostStatus) {
        this.getHolder().setHostStatus(hostStatus);
    }

    public int[] getSeverities() {
        return this.getHolder().getSeverities();
    }

    public void setSeverities(int[] severities) {
        this.getHolder().setSeverities(severities);
    }

    private String[] toString(ObjectID[] arr) {
        String[] result = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = this.toString(arr[i]);
        }
        return result;
    }

    private String toString(ObjectID id) {
        return id == null ? null : id.toString();
    }

    private HostSetID toHostSetID(String str) {
        return str == null ? null : new HostSetID(str);
    }

    private HostID[] toHostID(String[] arr) {
        HostID[] result = new HostID[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            String hostStr = arr[i];
            result[i] = hostStr == null ? null : new HostID(hostStr);
        }
        return result;
    }

    public CriteriaMetaData toRPCSerializable() {
        return this.getHolder();
    }

    public static class IDFactory
    extends ObjectIDFactory {
        public ObjectID newInstance(String id) {
            return new CriteriaID(id);
        }

        public CriteriaID generateCriteriaID() {
            return (CriteriaID)this.generateObjectID();
        }
    }
}

