/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaShorthand;
import com.raplix.util.enum.EnumFactory;
import com.raplix.util.message.MessageManager;
import java.util.Arrays;

class EventTypeShorthand
extends CriteriaShorthand {
    private String mName;
    private String mDisplayNameCode;
    private String[] mEventTypes;
    private int mTaskEventType;
    private int mHostStatus;

    public EventTypeShorthand(String name, String displayNameCode, Class[] eventTypes, int taskEventType, int hostStatus, EnumFactory inFactory) {
        super(name, inFactory);
        this.setName(name);
        this.setDisplayNameCode(displayNameCode);
        this.setEventTypes(eventTypes);
        this.setTaskEventType(taskEventType);
        this.setHostStatus(hostStatus);
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    private String getDisplayNameCode() {
        return this.mDisplayNameCode;
    }

    private void setDisplayNameCode(String displayNameCode) {
        this.mDisplayNameCode = displayNameCode;
    }

    public String getDisplayName() {
        return MessageManager.messageAsString(this.getDisplayNameCode());
    }

    private String[] getEventTypes() {
        return this.mEventTypes;
    }

    private void setEventTypes(String[] eventTypes) {
        this.mEventTypes = eventTypes;
    }

    private void setEventTypes(Class[] eventClasses) {
        String[] eventTypes = new String[eventClasses.length];
        for (int i = 0; i < eventClasses.length; ++i) {
            eventTypes[i] = eventClasses[i].getName();
        }
        this.setEventTypes(eventTypes);
    }

    private int getTaskEventType() {
        return this.mTaskEventType;
    }

    private void setTaskEventType(int taskEventType) {
        this.mTaskEventType = taskEventType;
    }

    private int getHostStatus() {
        return this.mHostStatus;
    }

    private void setHostStatus(int hostStatus) {
        this.mHostStatus = hostStatus;
    }

    public void apply(CriteriaMetaData criteria) {
        criteria.setEventTypes(this.getEventTypes());
        criteria.setTaskEventType(this.getTaskEventType());
        criteria.setHostStatus(this.getHostStatus());
    }

    public boolean appliesTo(CriteriaMetaData criteria) {
        return Arrays.equals(this.getEventTypes(), criteria.getEventTypes()) && this.getTaskEventType() == criteria.getTaskEventType() && this.getHostStatus() == criteria.getHostStatus();
    }
}

