/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.rule.Action;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import com.raplix.util.mail.Email;

public class EmailAction
implements Action {
    private String mEmailAddress;
    private String mMailServerName;
    private String mSubject;
    private String mSenderAddress;
    private static final String MSG_EMAIL_FAILED = "event.rule.action.EMAIL_FAILED";

    public EmailAction(ActionMetaData actionMetaData, String inMailServerName, String inSubject, String inSenderAddress, RuleMetaData ruleMetaData) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("EmailAction to " + inMailServerName + " about " + inSubject + " from " + inSenderAddress, this);
        }
        this.setEmailAddress(actionMetaData.getEmailAddress());
        this.setMailServerName(inMailServerName);
        this.setSubject(inSubject);
        this.setSenderAddress(inSenderAddress);
    }

    public EmailAction() {
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public void setEmailAddress(String inEmailAddress) {
        this.mEmailAddress = inEmailAddress;
    }

    public String getMailServerName() {
        return this.mMailServerName;
    }

    public void setMailServerName(String inMailServerName) {
        this.mMailServerName = inMailServerName;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public void setSubject(String inSubject) {
        this.mSubject = inSubject;
    }

    public String getSenderAddress() {
        return this.mSenderAddress;
    }

    public void setSenderAddress(String inSenderAddress) {
        this.mSenderAddress = inSenderAddress;
    }

    protected String getBody(ROXEvent anEvent) {
        return anEvent.getEmailContent();
    }

    public void eventHappened(ROXEvent event) {
        block2: {
            Email message = new Email();
            message.setMailServer(this.getMailServerName());
            message.setTo(this.getEmailAddress());
            message.setSubject(this.getSubject());
            message.setFrom(this.getSenderAddress());
            message.setBody(this.getBody(event));
            try {
                message.send();
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(this)) break block2;
                String msg = ROXMessageManager.messageAsString(MSG_EMAIL_FAILED, new Object[]{event});
                Logger.warn(msg, e, this);
            }
        }
    }
}

