/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.AffectedHost;
import com.raplix.rolloutexpress.event.AffectedTarget;
import com.raplix.rolloutexpress.event.HostStatus;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXNotificationRule;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobInterface;
import com.raplix.rolloutexpress.event.query.bean.HostInterface;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentInterface;
import com.raplix.rolloutexpress.event.query.bean.TargetInterface;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class Criteria
implements ROXNotificationRule {
    private static final String MSG_INVALID_PATTERN = "event.rule.criteria.INVALID_PATTERN";
    private static final String MSG_TARGET_LOOKUP_ERROR = "event.rule.criteria.TARGET_LOOKUP_ERROR";
    private static final String MSG_HOST_LOOKUP_ERROR = "event.rule.criteria.HOST_LOOKUP_ERROR";
    private RegEx mMessagePattern;
    private CriteriaMetaData mMetaData;

    Criteria(CriteriaMetaData metaData) {
        this.setMetaData(metaData);
        this.setMessagePattern(metaData.getMessagePattern());
    }

    private void setMessagePattern(String pattern) {
        RegEx regex;
        if (pattern == null || pattern.length() == 0) {
            return;
        }
        pattern = "*" + pattern + "*";
        try {
            regex = new RegEx(RegEx.createPreciseWildcard(pattern.toLowerCase()));
        }
        catch (RegExSyntaxException e) {
            String message = MessageManager.messageAsString(MSG_INVALID_PATTERN, new Object[]{pattern});
            throw new IllegalArgumentException(message);
        }
        this.setMessagePattern(regex);
    }

    private RegEx getMessagePattern() {
        return this.mMessagePattern;
    }

    private void setMessagePattern(RegEx messagePattern) {
        this.mMessagePattern = messagePattern;
    }

    private CriteriaMetaData getMetaData() {
        return this.mMetaData;
    }

    private void setMetaData(CriteriaMetaData metaData) {
        this.mMetaData = metaData;
    }

    public boolean isInteresting(ROXEvent event) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("NotificationRule considering event " + event, this);
        }
        return this.matchesEventType(event) && this.matchesMessage(event) && this.matchesTaskType(event) && this.matchesAnyHost(event) && this.matchesSeverities(event);
    }

    private boolean matchesEventType(ROXEvent event) {
        Object[] eventTypes;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Examining EventType...", this);
        }
        if (this.isEmpty(eventTypes = this.getMetaData().getEventTypes())) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No EventType to match - ignoring EventType", this);
            }
            return true;
        }
        int len = eventTypes.length;
        String currentType = event.getClass().getName();
        for (int i = 0; i < len; ++i) {
            if (!currentType.equals(eventTypes[i])) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("EventType matches", this);
            }
            return true;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("EventType does not match", this);
        }
        return false;
    }

    private boolean matchesMessage(ROXEvent event) {
        RegEx pattern;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Examining Message...", this);
        }
        if ((pattern = this.getMessagePattern()) == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No pattern to match, ignoring message", this);
            }
            return true;
        }
        boolean matches = pattern.match(event.getMessage().toLowerCase());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Matching pattern " + pattern + " to " + event.getMessage().toLowerCase() + " - " + (matches ? "matches" : "does not match"), this);
        }
        return matches;
    }

    private boolean matchesTaskType(ROXEvent event) {
        boolean matches;
        int type;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Examining RunLevel...", this);
        }
        if ((type = this.getMetaData().getTaskEventType()) == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No runlevel specified to match, ignoring runlevel", this);
            }
            return true;
        }
        if (!(event instanceof ROXTaskEvent)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Event not a task-related event, ignoring runlevel", this);
            }
            return true;
        }
        boolean isPreflight = type == 1;
        boolean bl = matches = ((ROXTaskEvent)event).getIsPreflight() == isPreflight;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Matching runlevel - " + matches, this);
        }
        return matches;
    }

    private boolean matchesAnyHost(ROXEvent event) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Entering matchesAnyHost with event " + event, this);
        }
        if (this.ignoreHosts()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No hosts to match, checking status", this);
            }
            return this.matchesHostStatus(event);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Matching host or hostset", this);
        }
        return this.matchesHosts(event) || this.matchesHostSet(event);
    }

    private boolean ignoreHosts() {
        return this.isEmpty(this.getMetaData().getHosts()) && this.getMetaData().getHostSet() == null;
    }

    private boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    private boolean matchesHostStatus(ROXEvent event) {
        int criteriaStatus;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Entering matchesHostStatus with event " + event, this);
        }
        if ((criteriaStatus = this.getMetaData().getHostStatus()) == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Ignoring status", this);
            }
            return true;
        }
        HashMap map = this.getAllAffectedHosts(event);
        if (map == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No status applicable to event - ignoring status", this);
            }
            return true;
        }
        Iterator stats = map.values().iterator();
        while (stats.hasNext()) {
            HostStatus hs = (HostStatus)stats.next();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matching event status " + hs + " to rule status " + criteriaStatus, this);
            }
            if (hs == null || hs.getStatus() != criteriaStatus) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Status matches", this);
            }
            return true;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("No status match found", this);
        }
        return false;
    }

    private HashMap getAllAffectedHosts(ROXEvent event) {
        HashMap<HostID, HostStatus> result = null;
        if (event instanceof AffectedHost) {
            HostStatus[] hs = ((AffectedHost)((Object)event)).getAllAffectedHosts();
            result = new HashMap<HostID, HostStatus>();
            for (int i = 0; i < hs.length; ++i) {
                result.put(hs[i].getHostID(), hs[i]);
            }
        } else if (event instanceof AffectedTarget) {
            result = this.getAllAffectedHosts((AffectedTarget)((Object)event), TargetType.INITIAL);
        } else if (event instanceof HostInterface) {
            result = new HashMap<HostID, HostStatus>();
            result.put(((HostInterface)((Object)event)).getHostID(), null);
        }
        return result;
    }

    private HashMap getAllAffectedHosts(AffectedTarget at, TargetType targetType) {
        HashMap<HostID, HostStatus> hostStatusMap;
        block6: {
            hostStatusMap = null;
            try {
                int i;
                TargetStatus[] tsa = at.getAllAffectedTargets();
                TargetIDSet idSet = new TargetIDSet();
                for (int i2 = 0; i2 < tsa.length; ++i2) {
                    idSet.add(tsa[i2].getTargetID());
                }
                SummaryTarget[] targets = idSet.getByIDsQuery().selectSummaryView();
                HashMap<TargetID, SummaryTarget> targetMap = new HashMap<TargetID, SummaryTarget>();
                for (i = 0; i < targets.length; ++i) {
                    targetMap.put(targets[i].getID(), targets[i]);
                }
                hostStatusMap = new HashMap<HostID, HostStatus>();
                for (i = 0; i < tsa.length; ++i) {
                    TargetStatus ts = tsa[i];
                    SummaryTarget t = (SummaryTarget)targetMap.get(ts.getTargetID());
                    HostID hostID = t.getHostID(targetType);
                    HostStatus hs = (HostStatus)hostStatusMap.get(hostID);
                    if (hs == null) {
                        hs = new HostStatus(hostID, ts.getStatus());
                        hostStatusMap.put(hostID, hs);
                        continue;
                    }
                    if (hs.getStatus() >= ts.getStatus()) continue;
                    hs.setStatus(ts.getStatus());
                }
            }
            catch (CommandException e) {
                if (!Logger.isWarnEnabled(this)) break block6;
                Logger.warn(MessageManager.messageAsString(MSG_TARGET_LOOKUP_ERROR), e, this);
            }
        }
        return hostStatusMap;
    }

    private boolean matchesHosts(ROXEvent event) {
        HostID[] hosts;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Entering matchesHosts with " + event, this);
        }
        if ((hosts = this.getMetaData().getHosts()) == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No hosts are specified for this criteria - no match", this);
            }
            return false;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(hosts.length + " hosts are specified for this criteria", this);
        }
        HashMap hostStatusMap = this.getAllAffectedHosts(event);
        int len = hosts.length;
        for (int i = 0; i < len; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Examining host status for host " + hosts[i] + " to see if the event matches", this);
            }
            if (!this.eventContainsHost(event, hosts[i])) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Event does contain host " + hosts[i], this);
            }
            if (hostStatusMap == null) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("No host status specified - it's a match", this);
                }
                return true;
            }
            HostStatus match = (HostStatus)hostStatusMap.get(hosts[i]);
            if (match != null && !this.matchesStatus(match)) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matching host status or host status not applicable - it's a match", this);
            }
            return true;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("No host match found", this);
        }
        return false;
    }

    private HostID[] distillHostsFromEvent(ROXEvent inEvent) {
        block13: {
            DifferenceSettings ds;
            Object host;
            block12: {
                if (inEvent instanceof HostInterface && (host = ((HostInterface)((Object)inEvent)).getHostID()) != null) {
                    return new HostID[]{host};
                }
                if (inEvent instanceof TargetInterface && (host = ((TargetInterface)((Object)inEvent)).getHostID()) != null) {
                    return new HostID[]{host};
                }
                if (inEvent instanceof AffectedTarget) {
                    AffectedTarget target = (AffectedTarget)((Object)inEvent);
                    try {
                        TargetStatus[] statuses = target.getAllAffectedTargets();
                        LinkedList<HostID> hosts = new LinkedList<HostID>();
                        for (int i = 0; i < statuses.length; ++i) {
                            hosts.add(statuses[i].getHostID());
                        }
                        return hosts.toArray(new HostID[0]);
                    }
                    catch (PlanExecutionException e) {
                        if (!Logger.isWarnEnabled(this)) break block12;
                        Logger.warn(MessageManager.messageAsString(MSG_TARGET_LOOKUP_ERROR), e, this);
                    }
                }
            }
            if (inEvent instanceof AffectedHost) {
                host = (AffectedHost)((Object)inEvent);
                HostStatus[] statuses = host.getAllAffectedHosts();
                LinkedList<HostID> hosts = new LinkedList<HostID>();
                for (int i = 0; i < statuses.length; ++i) {
                    hosts.add(statuses[i].getHostID());
                }
                return hosts.toArray(new HostID[0]);
            }
            if (inEvent instanceof DifferenceJobInterface && (ds = ((DifferenceJobInterface)((Object)inEvent)).getDifferenceSettings()) != null) {
                return new HostID[]{new HostID(ds.getSrcHostID()), new HostID(ds.getDstHostID())};
            }
            if (inEvent instanceof InstalledComponentInterface) {
                TargetID targetID = ((InstalledComponentInterface)((Object)inEvent)).getTargetID();
                try {
                    SummaryTarget target = targetID.getByIDQuery().selectSummaryView();
                    return new HostID[]{target.getInitialHostID()};
                }
                catch (Exception e) {
                    if (!Logger.isWarnEnabled(this)) break block13;
                    Logger.warn(MessageManager.messageAsString(MSG_TARGET_LOOKUP_ERROR), e, this);
                }
            }
        }
        return null;
    }

    private boolean eventContainsHost(ROXEvent inEvent, HostID inHost) {
        HostID[] eventHostID = this.distillHostsFromEvent(inEvent);
        if (eventHostID == null) {
            return false;
        }
        for (int i = 0; i < eventHostID.length; ++i) {
            if (!eventHostID[i].equals(inHost)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesStatus(HostStatus hs) {
        if (hs == null) {
            return false;
        }
        int criteriaStatus = this.getMetaData().getHostStatus();
        if (criteriaStatus == 0) {
            return true;
        }
        return criteriaStatus == hs.getStatus();
    }

    private boolean matchesHostSet(ROXEvent event) {
        block16: {
            HostSetID hostSetID;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Entering matchesHostSet for event " + event, this);
            }
            if ((hostSetID = this.getMetaData().getHostSet()) == null) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("No hostset specified in the criteria - no match", this);
                }
                return false;
            }
            HostID[] hostID = this.distillHostsFromEvent(event);
            if (hostID == null) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("The event yielded no hosts - no match", this);
                }
                return false;
            }
            try {
                HashMap hostStatusMap = this.getAllAffectedHosts(event);
                for (int i = 0; i < hostID.length; ++i) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Matching host " + hostID[i] + " to event", this);
                    }
                    if (!hostSetID.contains(hostID[i])) continue;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Hostset contains host, matching status", this);
                    }
                    if (hostStatusMap == null) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("No status specified - it's a match", this);
                        }
                        return true;
                    }
                    HostStatus status = (HostStatus)hostStatusMap.get(hostID[i]);
                    if (status != null && !this.matchesStatus(status)) continue;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Either status matches or no status for the host - it's a match", this);
                    }
                    return true;
                }
            }
            catch (PersistenceManagerException e) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(MessageManager.messageAsString(MSG_HOST_LOOKUP_ERROR), e, this);
                }
            }
            catch (RPCException e) {
                if (!Logger.isWarnEnabled(this)) break block16;
                Logger.warn(MessageManager.messageAsString(MSG_HOST_LOOKUP_ERROR), e, this);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("No hostset match found", this);
        }
        return false;
    }

    private boolean matchesSeverities(ROXEvent event) {
        int[] severities;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Entering matchesSeverities with event " + event, this);
        }
        if ((severities = this.getMetaData().getSeverities()) == null || severities.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No severities to match, ignoring severities", this);
            }
            return true;
        }
        int len = severities.length;
        int currentSeverity = event.getSeverity();
        for (int i = 0; i < len; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matching rule severity " + severities[i] + " to event severity " + currentSeverity, this);
            }
            if (currentSeverity != severities[i]) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Severity matches", this);
            }
            return true;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("No severity match found", this);
        }
        return false;
    }
}

