/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.rule.ActionID;
import com.raplix.rolloutexpress.event.rule.MetaDataBase;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.util.mail.Email;
import com.raplix.util.string.StringUtil;
import javax.mail.internet.AddressException;

public class ActionMetaData
extends MetaDataBase {
    private static final String MSG_INVALID_ACTION_TYPE = "event.rule.action.INVALID_ACTION_TYPE";
    private static final String MSG_INVALID_EMAIL_ADDRESS = "event.rule.action.INVALID_EMAIL_ADDRESS";
    private ActionID mActionID;
    public static final String EMAIL_ACTION_TYPE = "EMAIL";
    private String mActionType;
    private String mEmailAddress;
    public static final int MAX_EMAIL_LENGTH = 1024;

    public ActionID getActionID() {
        return this.mActionID;
    }

    public void setActionID(ActionID actionID) {
        this.mActionID = actionID;
    }

    public String getActionType() {
        return this.mActionType;
    }

    public void setActionType(String actionType) {
        this.mActionType = actionType;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.mEmailAddress = emailAddress;
    }

    public void validate() throws RuleException {
        String actionType = this.getActionType();
        if (!actionType.equals(EMAIL_ACTION_TYPE)) {
            throw new RuleException(MSG_INVALID_ACTION_TYPE);
        }
        String emailAddress = this.getEmailAddress();
        if (StringUtil.isEmpty(emailAddress) || emailAddress.length() > 1024) {
            throw new RuleException(MSG_INVALID_EMAIL_ADDRESS);
        }
        try {
            Email.parseInternetAddress(emailAddress);
        }
        catch (AddressException e) {
            throw new RuleException(MSG_INVALID_EMAIL_ADDRESS, (Throwable)e);
        }
    }

    public boolean equals(Object other, boolean ignoreID) {
        if (other == null || !(other instanceof ActionMetaData)) {
            return false;
        }
        ActionMetaData otherAction = (ActionMetaData)other;
        return (ignoreID || this.equals((Object)this.getActionID(), otherAction.getActionID())) && this.equals((Object)this.getActionType(), otherAction.getActionType()) && this.equals((Object)this.getEmailAddress(), otherAction.getEmailAddress());
    }

    public int hashCode() {
        return this.hashCode(this.getActionID()) + this.hashCode(this.getActionType()) + this.hashCode(this.getEmailAddress());
    }

    public void toStringBuffer(StringBuffer buf, String prefix) {
        buf.append(prefix);
        buf.append("ActionMetaData{\n");
        String newPrefix = prefix + "  ";
        buf.append(newPrefix);
        buf.append("actionID=");
        buf.append(this.getActionID());
        buf.append("\n");
        buf.append(newPrefix);
        buf.append("actionType=");
        buf.append(this.getActionType());
        buf.append("\n");
        buf.append(newPrefix);
        buf.append("emailAddress=");
        buf.append(this.getEmailAddress());
        buf.append("\n");
        buf.append(prefix);
        buf.append("}\n");
    }
}

