/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.rule;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.rule.Action;
import com.raplix.rolloutexpress.event.rule.ActionFactory;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import java.util.HashMap;

public class ActionFactoryRegistry
implements ActionFactory,
Messages {
    private HashMap mFactories = new HashMap();

    public void registerFactory(String actionType, ActionFactory factory) {
        this.mFactories.put(actionType, factory);
    }

    public Action newAction(ActionMetaData actionMetaData, RuleMetaData ruleMetaData) {
        String actionType = actionMetaData.getActionType();
        ActionFactory factory = null;
        if (actionType != null) {
            factory = (ActionFactory)this.mFactories.get(actionType);
        }
        if (factory != null) {
            return factory.newAction(actionMetaData, ruleMetaData);
        }
        if (Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("event.NO_ACTION_FOR_ACTIONTYPE", new Object[]{actionType}), this);
        }
        return LoggerAction.INSTANCE;
    }

    private static final class LoggerAction
    implements Action {
        public static final LoggerAction INSTANCE = new LoggerAction();

        private LoggerAction() {
        }

        public void eventHappened(ROXEvent event) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("event.NO_HANDLER_FOR_EVENT", new Object[]{event}), this);
            }
        }
    }
}

