/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.UserInterface;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

public class UserBean
extends ParentBean
implements UserInterface {
    private UserID mUserID;
    private String mUsername;

    public UserBean() {
    }

    public UserBean(UserID inUserID, String inUsername) {
        this.mUserID = inUserID;
        this.mUsername = inUsername;
        this.setIsValid(true);
    }

    public UserBean(Application inApplication) {
        super(inApplication);
    }

    public void setUserID(UserID inUserID, Application inApplication) {
        if (null == inUserID) {
            throw new NullPointerException();
        }
        if (this.mUserID == null || !inUserID.equals(this.mUserID)) {
            this.mUserID = inUserID;
            this.lookupUser(inApplication);
        }
    }

    public void setUserID(UserID inUserID) {
        this.setUserID(inUserID, null);
    }

    public void setUsername(String inUsername) {
        this.mUsername = inUsername;
    }

    public UserID getUserID() {
        return this.mUserID;
    }

    public String getUsername() {
        return this.mUsername;
    }

    private void lookupUser(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mUsername = this.getApp().getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getUser(this.mUserID).getUsername();
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mUsername = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupUser(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

