/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;

public class TaskBean
extends ParentBean
implements TaskInterface {
    private TaskID mTaskID;
    private TaskInfo mTaskInfo;
    private boolean mIsPreflight;
    private boolean mPreflightInUse = false;

    public TaskBean() {
    }

    public TaskBean(TaskInfo inTaskInfo) {
        this.mTaskInfo = inTaskInfo;
        this.mTaskID = inTaskInfo.getTaskID();
        this.setIsValid(true);
    }

    public TaskBean(Application inApplication) {
        super(inApplication);
    }

    public void setTaskID(TaskID inTaskID) {
        this.setTaskID(inTaskID, null);
    }

    public void setTaskID(TaskID inTaskID, Application inApplication) {
        if (null == inTaskID) {
            throw new NullPointerException();
        }
        if (this.mTaskID == null || !inTaskID.equals(this.mTaskID)) {
            this.mTaskID = inTaskID;
            this.lookupTask(inApplication);
        }
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public TaskInfo getTaskInfo() {
        return this.mTaskInfo;
    }

    public boolean getIsPreflight() {
        return this.mIsPreflight;
    }

    public boolean preflightInUse() {
        return this.mPreflightInUse;
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mIsPreflight = isPreflight;
        this.mPreflightInUse = true;
    }

    private void lookupTask(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mTaskInfo = this.getApp().getPlanSubsystem().getTaskInfoForTaskID(this.mTaskID);
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mTaskInfo = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupTask(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

