/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.StepInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;

public class StepBean
extends ParentBean
implements StepInterface {
    private StepID mStepID;
    private StepInfo mStepInfo;

    public StepBean() {
    }

    public StepBean(StepInfo inStepInfo) {
        this.mStepInfo = inStepInfo;
        this.mStepID = inStepInfo.getStepID();
        this.setIsValid(true);
    }

    public StepBean(Application inApplication) {
        super(inApplication);
    }

    public void setStepID(StepID inStepID) {
        this.setStepID(inStepID, null);
    }

    public void setStepID(StepID inStepID, Application inApplication) {
        if (null == inStepID) {
            throw new NullPointerException();
        }
        if (this.mStepID == null || !inStepID.equals(this.mStepID)) {
            this.mStepID = inStepID;
        }
    }

    public StepID getStepID() {
        return this.mStepID;
    }

    public int getStepType() {
        StepInfo info = this.getStepInfo();
        if (null == info) {
            return -1;
        }
        return info.getStepType();
    }

    public StepInfo getStepInfo() {
        if (null == this.mStepInfo) {
            this.doLookup();
        }
        return this.mStepInfo;
    }

    private void lookupStep(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mStepInfo = this.getApp().getPlanSubsystem().getStepInfoForStepID(this.mStepID);
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mStepInfo = null;
        }
    }

    public void doLookup() {
        this.lookupStep(null);
    }
}

