/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

public class RunningPlanBean
extends ParentBean
implements RPCSerializable,
ExecutionPlanInterface,
TaskInterface,
HasObjectID,
UsingObject {
    private ExecutionPlanBean mExecutionPlan;
    private TaskBean mTask;
    private boolean mIsRunning;
    private TaskStatus mTaskStatus;
    public static final StatusDateRunningPlanBeanComparator STATUSDATERUNNINGPLANBEAN_COMPARATOR = new StatusDateRunningPlanBeanComparator();

    public RunningPlanBean() {
        this.mExecutionPlan = new ExecutionPlanBean();
        this.mTask = new TaskBean();
        this.mIsRunning = false;
    }

    public RunningPlanBean(TaskBean inTaskBean, ExecutionPlanBean inExecutionPlanBean) {
        this.mExecutionPlan = inExecutionPlanBean;
        this.mTask = inTaskBean;
        this.mIsRunning = false;
        this.setTaskStatus(inTaskBean.getTaskInfo().getTaskStatus());
    }

    public ObjectID getObjectID() {
        return this.getTaskID();
    }

    public TaskStatus getTaskStatus() {
        return this.mTaskStatus;
    }

    private void setTaskBean(TaskBean inTaskBean) {
        this.mTask = inTaskBean;
    }

    private void setPlanBean(ExecutionPlanBean inPlanBean) {
        this.mExecutionPlan = inPlanBean;
    }

    public void setTaskStatus(TaskStatus inTaskStatus) {
        this.mTaskStatus = inTaskStatus;
    }

    public void setTaskID(TaskID inTaskID, Application inApplication) {
        this.mTask.setTaskID(inTaskID, inApplication);
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTask.setTaskID(inTaskID);
    }

    public TaskID getTaskID() {
        return this.mTask.getTaskID();
    }

    public TaskInfo getTaskInfo() {
        return this.mTask.getTaskInfo();
    }

    public boolean getIsPreflight() {
        return this.mTask.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mTask.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mTask.preflightInUse();
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID, Application inApplication) {
        this.mExecutionPlan.setExecutionPlanID(inExecutionPlanID, inApplication);
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID) {
        this.mExecutionPlan.setExecutionPlanID(inExecutionPlanID);
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlan.getExecutionPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mExecutionPlan.getExecutionPlan();
    }

    public Date getStartDate() {
        if (null == this.getTaskInfo()) {
            return null;
        }
        return this.getTaskInfo().getTaskStart();
    }

    public Date getCompleteDate() {
        if (null == this.getTaskInfo()) {
            return null;
        }
        return this.getTaskInfo().getTaskComplete();
    }

    public void setIsRunning(boolean inIsRunning) {
        this.mIsRunning = inIsRunning;
    }

    public boolean getIsRunning() {
        return this.mIsRunning;
    }

    public String getName() {
        SummaryExecutionPlan plan = this.getExecutionPlan();
        return null == plan ? "" : this.getExecutionPlan().getName();
    }

    public String getDescription() {
        SummaryExecutionPlan plan = this.getExecutionPlan();
        return null == plan ? "" : this.getExecutionPlan().getDescription();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(RunningPlanBean.class.getName()).append("(").append(super.toString()).append("\n");
        buf.append("\tTask: ").append(this.getTaskID() == null ? "null" : this.getTaskID().toString()).append("\n");
        buf.append("\tPlan: ").append(this.getExecutionPlanID() == null ? "null" : this.getExecutionPlanID().toString()).append("\n");
        buf.append("\tStartDate: ").append(this.getStartDate() == null ? "null" : this.getStartDate().toString()).append("\n");
        buf.append("\tCompleteDate: ").append(this.getCompleteDate() == null ? "null" : this.getCompleteDate().toString()).append("\n");
        buf.append("\tIsRunning: ").append(this.getIsRunning()).append("\n");
        buf.append("\tStatus: ").append(this.getTaskStatus()).append("\n");
        return buf.toString();
    }

    public void doLookup() {
    }

    public static class StatusDateRunningPlanBeanComparator
    implements Comparator {
        public boolean equals(Object o) {
            return o instanceof StatusDateRunningPlanBeanComparator;
        }

        public int compare(Object lhs, Object rhs) {
            RunningPlanBean left = (RunningPlanBean)lhs;
            RunningPlanBean right = (RunningPlanBean)rhs;
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            if (left.getIsRunning() != right.getIsRunning()) {
                return left.getIsRunning() ? -1 : 1;
            }
            if (left.getIsRunning()) {
                Date leftStart = left.getStartDate();
                Date rightStart = right.getStartDate();
                if (leftStart == null) {
                    return rightStart == null ? 0 : -1;
                }
                if (rightStart == null) {
                    return 1;
                }
                if (!leftStart.equals(rightStart)) {
                    return leftStart.getTime() > rightStart.getTime() ? -1 : 1;
                }
            } else {
                Date leftComplete = left.getCompleteDate();
                Date rightComplete = right.getCompleteDate();
                if (leftComplete == null) {
                    return rightComplete == null ? 0 : -1;
                }
                if (rightComplete == null) {
                    return 1;
                }
                if (!leftComplete.equals(rightComplete)) {
                    return leftComplete.getTime() > rightComplete.getTime() ? 1 : -1;
                }
            }
            return 0;
        }
    }

    public static class RunningPlanBeanResultSetProcessor
    extends ResultSetProcessor {
        Vector mResults = new Vector();
        TaskInfoTable mTaskInfoTable;
        ROXEventFactoryTable mEventTable;
        ExecutionPlanImplTable mPlanTable;

        public RunningPlanBeanResultSetProcessor(ROXEventFactoryTable inEventFactoryTable, TaskInfoTable inTaskInfoTable, ExecutionPlanImplTable inPlanTable) {
            this.mEventTable = inEventFactoryTable;
            this.mTaskInfoTable = inTaskInfoTable;
            this.mPlanTable = inPlanTable;
        }

        public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException, QueryException {
            while (inResultSet.next()) {
                TaskInfo info = this.mTaskInfoTable.retrieveObject(inResultSet);
                SummaryExecutionPlan thePlan = SummaryExecutionPlan.createFromResultSet(this.mPlanTable, inResultSet);
                ROXEventFactory event = this.mEventTable.retrieveObject(inResultSet);
                RunningPlanBean theBean = new RunningPlanBean();
                theBean.setTaskBean(new TaskBean(info));
                theBean.setPlanBean(new ExecutionPlanBean(thePlan));
                theBean.setIsPreflight(event.getIsPreflight());
                theBean.setTaskStatus(info.getTaskStatus());
                theBean.setIsRunning(info.getTaskComplete() == null);
                this.mResults.add(theBean);
            }
        }

        public boolean loadAssociations() {
            return false;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }
}

