/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceJob;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceJobTable;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public class RunningDiffBean
extends ParentBean
implements DifferenceJobInterface {
    private DifferenceSettings mDifferenceSettings;
    private DifferenceJob mDifferenceJob;
    private boolean mIsRunning = false;

    public RunningDiffBean() {
    }

    public RunningDiffBean(DifferenceSettings inSettings, DifferenceJob inDiffJob) {
        this.mDifferenceSettings = inSettings;
        this.mDifferenceJob = inDiffJob;
        this.setIsValid(true);
    }

    public boolean getIsRunning() {
        return this.mIsRunning;
    }

    public void setIsRunning(boolean inIsRunning) {
        this.mIsRunning = inIsRunning;
    }

    public Date getStartDate() {
        DifferenceJob j = this.getDifferenceJob();
        return null == j ? null : j.getDifferenceStart();
    }

    public Date getCompleteDate() {
        DifferenceJob j = this.getDifferenceJob();
        return null == j ? null : j.getDifferenceComplete();
    }

    public DifferenceJobID getDifferenceJobID() {
        DifferenceJob j = this.getDifferenceJob();
        return null == j ? null : j.getID();
    }

    public DifferenceSettingsID getDifferenceSettingsID() {
        return (DifferenceSettingsID)this.mDifferenceSettings.getObjectID();
    }

    public DifferenceSettings getDifferenceSettings() {
        return this.mDifferenceSettings;
    }

    public DifferenceJob getDifferenceJob() {
        return this.mDifferenceJob;
    }

    public void doLookup() {
    }

    public static class RunningDiffBeanResultSetProcessor
    extends ResultSetProcessor {
        Vector mResults = new Vector();
        ROXEventFactoryTable mEventTable;
        DifferenceJobTable mDiffJobTable;
        DifferenceSettingsTable mDiffSettingsTable;

        public RunningDiffBeanResultSetProcessor(DifferenceJobTable inDiffJobTable, DifferenceSettingsTable inDiffSettingsTable) {
            this.mDiffJobTable = inDiffJobTable;
            this.mDiffSettingsTable = inDiffSettingsTable;
        }

        public void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException {
            while (inResultSet.next()) {
                DifferenceJob theDiffJob = this.mDiffJobTable.retrieveObject(inResultSet);
                DifferenceSettings theDiffSettings = this.mDiffSettingsTable.retrieveObject(inResultSet);
                RunningDiffBean theBean = new RunningDiffBean(theDiffSettings, theDiffJob);
                theBean.setIsRunning(theDiffJob.getDifferenceComplete() == null);
                this.mResults.add(theBean);
            }
        }

        public boolean loadAssociations() {
            return false;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }
}

