/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.ResourceInterface;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.RsrcInfo;

public class ResourceBean
extends ParentBean
implements ResourceInterface {
    private ResourceID mResourceID;
    private RsrcInfo mResourceInfo;
    private String mResourceInstallPath;

    public ResourceBean() {
    }

    public ResourceBean(ResourceID inResourceID, RsrcInfo inRsrcInfo, String inPath) {
        this.mResourceID = inResourceID;
        this.mResourceInfo = inRsrcInfo;
        this.mResourceInstallPath = inPath;
        this.setIsValid(true);
    }

    public ResourceBean(Application inApplication) {
        super(inApplication);
    }

    public void setResourceID(ResourceID inResourceID, Application inApplication) {
        if (null == inResourceID) {
            throw new NullPointerException();
        }
        if (this.mResourceID == null || !inResourceID.equals(this.mResourceID)) {
            this.mResourceID = inResourceID;
            this.lookupResource(inApplication);
        }
    }

    public void setResourceID(ResourceID inResourceID) {
        this.setResourceID(inResourceID, null);
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public RsrcInfo getResourceInfo() {
        return this.mResourceInfo;
    }

    public String getResourceInstallPath() {
        return this.mResourceInstallPath;
    }

    public void setResourceInstallPath(String inPath) {
        this.mResourceInstallPath = inPath;
    }

    private void lookupResource(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mResourceInfo = this.getApp().getResourceSubsystem().getRsrcInfo(this.mResourceID, null);
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mResourceInfo = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupResource(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

