/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.event.query.bean.InstalledResourceInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public class InstalledResourceBean
extends ParentBean
implements RPCSerializable,
InstalledResourceInterface {
    private InstalledResource mInstalledResource = null;
    private InstalledResourceID mInstalledResourceID = null;
    private InstalledComponentBean mInstalledComponentBean;
    private boolean mIsPreflight;
    private boolean mPreflightInUse;
    private RsrcInfo mResourceInfo;
    private String mRAInstallPath = null;

    public InstalledResourceBean() {
    }

    public InstalledResourceBean(InstalledResourceID installedResourceID) {
        this.setInstalledResourceID(installedResourceID);
    }

    public InstalledResourceBean(InstalledResource installedResource, RsrcInfo rsrcInfo, InstalledComponentBean installedComponentBean) {
        this.mInstalledResource = installedResource;
        this.mInstalledResourceID = installedResource.getID();
        this.setIsValid(true);
        this.mResourceInfo = rsrcInfo;
        this.mInstalledComponentBean = installedComponentBean;
    }

    public InstalledResourceID getInstalledResourceID() {
        return this.mInstalledResourceID;
    }

    public void setInstalledResourceID(InstalledResourceID inInstalledResourceID) {
        if (null == inInstalledResourceID) {
            throw new NullPointerException();
        }
        if (this.mInstalledResourceID == null || !inInstalledResourceID.equals(this.mInstalledResourceID)) {
            this.mInstalledResourceID = inInstalledResourceID;
            this.lookupInstalledResource();
        }
    }

    public void setInstalledResource(InstalledResource inInstalledResource) {
        if (null == inInstalledResource) {
            throw new NullPointerException();
        }
        this.mInstalledResource = inInstalledResource;
        this.mInstalledResourceID = inInstalledResource.getID();
        this.mInstalledComponentBean = new InstalledComponentBean(inInstalledResource.getInstalledComponentID());
    }

    private void lookupInstalledResource() {
        try {
            this.mInstalledResource = this.getInstalledResourceID().getByIDQuery().select();
            this.mInstalledComponentBean = null;
            this.mResourceInfo = null;
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mInstalledResource = null;
        }
    }

    public InstalledResource getInstalledResource() {
        if (null == this.mInstalledResource) {
            this.lookupInstalledResource();
        }
        return this.mInstalledResource;
    }

    public InstalledComponentID getInstalledComponentID() {
        if (null == this.mInstalledResource) {
            this.lookupInstalledResource();
        }
        return this.isValid() ? this.mInstalledResource.getInstalledComponentID() : null;
    }

    public ResourceID getResourceID() {
        if (null == this.mInstalledResource) {
            this.lookupInstalledResource();
        }
        return this.isValid() ? this.mInstalledResource.getResourceID() : null;
    }

    public String getResourceInstallPath() {
        if (null == this.mInstalledResource) {
            this.lookupInstalledResource();
        }
        return this.isValid() ? this.mInstalledResource.getInstallPath() : null;
    }

    public String getResourceRAInstallPath() {
        if (this.mRAInstallPath != null) {
            return this.mRAInstallPath;
        }
        String universalPath = this.getResourceInstallPath();
        if (universalPath == null) {
            return null;
        }
        Target t = this.getTarget();
        if (t == null) {
            return null;
        }
        MachineInfo mi = t.getPhysicalHost().getMachineInfo();
        if (mi == null) {
            return null;
        }
        this.mRAInstallPath = mi.toRAPath(universalPath);
        return this.mRAInstallPath;
    }

    public InstalledComponent getInstalledComponent() {
        return this.getInstalledComponentBean().getInstalledComponent();
    }

    private InstalledComponentBean getInstalledComponentBean() {
        if (this.mInstalledComponentBean == null) {
            this.mInstalledComponentBean = new InstalledComponentBean(this.getInstalledComponentID());
        }
        return this.mInstalledComponentBean;
    }

    public HostID getHostID() {
        return this.getInstalledComponentBean().getHostID();
    }

    public SummaryHost getSummaryHost() {
        return this.getInstalledComponentBean().getSummaryHost();
    }

    public TargetID getTargetID() {
        return this.getInstalledComponentBean().getTargetID();
    }

    public void setTarget(Target t) {
        this.getInstalledComponentBean().setTarget(t);
    }

    public Target getTarget() {
        return this.getInstalledComponentBean().getTarget();
    }

    public TaskID getTaskID() {
        return this.getInstalledComponentBean().getTaskID();
    }

    public TaskInfo getTaskInfo() {
        return this.getInstalledComponentBean().getTaskInfo();
    }

    public GeneratedVariableSettingsID getGeneratedVariableSettingsID() {
        return this.getInstalledComponentBean().getGeneratedVariableSettingsID();
    }

    public String getComponentInstallPath() {
        return this.getInstalledComponentBean().getComponentInstallPath();
    }

    public String getComponentRAInstallPath() {
        return this.getInstalledComponentBean().getComponentRAInstallPath();
    }

    public SummaryComponent getComponent() {
        return this.getInstalledComponentBean().getComponent();
    }

    public ComponentID getComponentID() {
        return this.getInstalledComponentBean().getComponentID();
    }

    public boolean getIsPreflight() {
        return this.mIsPreflight;
    }

    public boolean preflightInUse() {
        return this.mPreflightInUse;
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mIsPreflight = isPreflight;
        this.mPreflightInUse = true;
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.getInstalledComponentBean().getExecutionPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.getInstalledComponentBean().getExecutionPlan();
    }

    public UserID getUserID() {
        return this.getInstalledComponentBean().getUserID();
    }

    public String getUsername() {
        return this.getInstalledComponentBean().getUsername();
    }

    public RsrcInfo getResourceInfo() {
        if (this.mResourceInfo == null) {
            this.lookupResource();
        }
        return this.mResourceInfo;
    }

    private void lookupResource() {
        try {
            this.mResourceInfo = this.getResourceID().getByIDQuery().select();
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mResourceInfo = null;
        }
    }

    public Date getDate() {
        if (null == this.getInstalledComponent()) {
            return null;
        }
        return this.getInstalledComponent().getInstallDate();
    }

    public void doLookup() {
    }
}

