/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.event.query.bean.ComponentBean;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.event.query.bean.TargetBean;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.UserBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public class InstalledComponentBean
extends ParentBean
implements RPCSerializable,
InstalledComponentInterface,
HasObjectID,
UsingObject {
    private InstalledComponent mInstalledComponent = null;
    private InstalledComponentID mInstalledComponentID = null;
    private TargetBean mTargetBean = null;
    private UserBean mUserBean = null;
    private ExecutionPlanBean mExecutionPlanBean = null;
    private TaskBean mTaskBean = null;
    private ComponentBean mComponentBean = null;
    private GeneratedVariableSettings mSettings = null;
    private String mRAInstallPath = null;
    private HostID mCreatedTarget = null;
    private boolean mCreatedTargetFetched = false;
    private boolean mIsPreflight;
    private boolean mPreflightInUse;

    public InstalledComponentBean() {
    }

    public InstalledComponentBean(InstalledComponentID installedComponentID) {
        this.setInstalledComponentID(installedComponentID);
    }

    public InstalledComponentBean(InstalledComponent installedComponent, UserBean inUserBean, ExecutionPlanBean inPlanBean, ComponentBean inComponentBean, GeneratedVariableSettings inGenVars, HostID inCreatedTarget, boolean createdTargetFetched) {
        this.mInstalledComponent = installedComponent;
        this.mInstalledComponentID = installedComponent.getID();
        this.setIsValid(true);
        this.mUserBean = inUserBean;
        this.mExecutionPlanBean = inPlanBean;
        this.mComponentBean = inComponentBean;
        this.mSettings = inGenVars;
        this.mCreatedTarget = inCreatedTarget;
        this.mCreatedTargetFetched = createdTargetFetched;
    }

    public ObjectID getObjectID() {
        return this.getInstalledComponentID();
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public void setInstalledComponentID(InstalledComponentID inInstalledComponentID) {
        if (null == inInstalledComponentID) {
            throw new NullPointerException();
        }
        if (this.mInstalledComponentID == null || !inInstalledComponentID.equals(this.mInstalledComponentID)) {
            this.mInstalledComponentID = inInstalledComponentID;
            this.lookupInstalledComponent(null);
        }
    }

    public InstalledComponent getInstalledComponent() {
        if (null == this.mInstalledComponent) {
            this.lookupInstalledComponent(null);
        }
        return this.mInstalledComponent;
    }

    public String getComponentInstallPath() {
        if (null == this.mInstalledComponent) {
            this.lookupInstalledComponent(null);
        }
        return this.isValid() ? this.getInstalledComponent().getInstallPath() : null;
    }

    public String getComponentRAInstallPath() {
        if (this.mRAInstallPath != null) {
            return this.mRAInstallPath;
        }
        String universalPath = this.getComponentInstallPath();
        if (universalPath == null) {
            return null;
        }
        Target t = this.getTarget();
        if (t == null) {
            return null;
        }
        MachineInfo mi = t.getPhysicalHost().getMachineInfo();
        if (mi == null) {
            return null;
        }
        this.mRAInstallPath = mi.toRAPath(universalPath);
        return this.mRAInstallPath;
    }

    public GeneratedVariableSettingsID getGeneratedVariableSettingsID() {
        return this.getInstalledComponent().getVariableSettingsID();
    }

    public GeneratedVariableSettings getGeneratedVariableSettings() {
        if (this.mSettings == null) {
            this.lookupGeneratedVariableSettings(null);
        }
        return this.mSettings;
    }

    public TargetID getTargetID() {
        return this.getInstalledComponent().getTargetID();
    }

    public Target getTarget() {
        return this.getTargetBean().getTarget();
    }

    public void setTarget(Target t) {
        if (!t.getID().equals(this.getTargetID())) {
            throw new IllegalArgumentException(t.getID().toString());
        }
        this.getTargetBean().setTarget(t);
    }

    private TargetBean getTargetBean() {
        if (this.mTargetBean == null) {
            this.mTargetBean = new TargetBean();
            this.mTargetBean.setTargetID(this.getTargetID());
        }
        return this.mTargetBean;
    }

    public HostID getCreatedTarget() {
        if (!this.mCreatedTargetFetched) {
            this.lookupCreatedTarget();
        }
        return this.mCreatedTarget;
    }

    public TaskID getTaskID() {
        return this.getInstalledComponent().getTaskID();
    }

    public HostID getHostID() {
        SummaryTarget theSummaryTarget = this.getTargetBean().getSummaryTarget();
        if (theSummaryTarget == null) {
            return null;
        }
        return theSummaryTarget.getCurrentHostID();
    }

    public SummaryHost getSummaryHost() {
        Target theTarget = this.getTargetBean().getTarget();
        if (theTarget == null) {
            return null;
        }
        return theTarget.getCurrentHost();
    }

    public TaskInfo getTaskInfo() {
        return this.getTaskBean().getTaskInfo();
    }

    private TaskBean getTaskBean() {
        if (this.mTaskBean == null) {
            this.mTaskBean = new TaskBean();
            this.mTaskBean.setTaskID(this.getTaskID());
        }
        return this.mTaskBean;
    }

    public boolean getIsPreflight() {
        return this.mIsPreflight;
    }

    public boolean preflightInUse() {
        return this.mPreflightInUse;
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mIsPreflight = isPreflight;
        this.mPreflightInUse = true;
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.getInstalledComponent().getPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.getExecutionPlanBean().getExecutionPlan();
    }

    private ExecutionPlanBean getExecutionPlanBean() {
        if (this.mExecutionPlanBean == null) {
            this.mExecutionPlanBean = new ExecutionPlanBean();
            this.mExecutionPlanBean.setExecutionPlanID(this.getExecutionPlanID());
        }
        return this.mExecutionPlanBean;
    }

    public UserID getUserID() {
        return this.getUserBean().getUserID();
    }

    public String getUsername() {
        return this.getUserBean().getUsername();
    }

    private UserBean getUserBean() {
        if (this.mUserBean == null) {
            this.mUserBean = new UserBean();
            this.mUserBean.setUserID(this.getTaskInfo().getRoxUser());
        }
        return this.mUserBean;
    }

    public SummaryComponent getComponent() {
        return this.getComponentBean().getComponent();
    }

    public ComponentID getComponentID() {
        return this.getInstalledComponent().getComponentID();
    }

    private ComponentBean getComponentBean() {
        if (this.mComponentBean == null) {
            this.mComponentBean = new ComponentBean();
            this.mComponentBean.setComponentID(this.getComponentID());
        }
        return this.mComponentBean;
    }

    public Date getDate() {
        if (this.getInstalledComponent() == null) {
            return null;
        }
        return this.getInstalledComponent().getInstallDate();
    }

    private void lookupGeneratedVariableSettings(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mSettings = this.getApp().getConfigGenSubsystem().getVariableSettings(this.getGeneratedVariableSettingsID());
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mSettings = null;
        }
    }

    private void lookupCreatedTarget() {
        try {
            this.mCreatedTarget = SingleHostQuery.byInstalledComponentID(this.mInstalledComponentID).selectSummaryView().getID();
            this.mCreatedTargetFetched = true;
        }
        catch (NoResultsFoundException e) {
            this.mCreatedTarget = null;
            this.mCreatedTargetFetched = true;
        }
        catch (PersistenceManagerException e) {
            this.logError(e);
            this.setIsValid(false);
            this.mCreatedTarget = null;
            this.mCreatedTargetFetched = false;
        }
        catch (RPCException e) {
            this.logError(e);
            this.setIsValid(false);
            this.mCreatedTarget = null;
            this.mCreatedTargetFetched = false;
        }
    }

    private void lookupInstalledComponent(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mInstalledComponent = this.mInstalledComponentID.getByIDQuery().select();
            this.mTaskBean = null;
            this.mExecutionPlanBean = null;
            this.mTargetBean = null;
            this.mComponentBean = null;
            this.mSettings = null;
            this.mCreatedTarget = null;
            this.mCreatedTargetFetched = false;
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mInstalledComponent = null;
        }
    }

    public void doLookup() {
        this.lookupInstalledComponent(null);
        this.lookupGeneratedVariableSettings(null);
    }

    public String getName() {
        return null == this.getComponent() ? "" : this.getComponent().getName();
    }

    public String getDescription() {
        return null == this.getComponent() ? "" : this.getComponent().getDescription();
    }
}

