/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanInterface;
import com.raplix.rolloutexpress.event.query.bean.HostBean;
import com.raplix.rolloutexpress.event.query.bean.HostInterface;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.event.query.bean.UserBean;
import com.raplix.rolloutexpress.event.query.bean.UserInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class HostHistoryBean
implements RPCSerializable,
TaskInterface,
HostInterface,
ExecutionPlanInterface,
UserInterface {
    public static final int RUNNING = 0;
    public static final int NORMAL = 1;
    public static final int NORMAL_WARNINGS = 2;
    public static final int INCOMPLETE_ABORT = 3;
    public static final int INCOMPLETE_TIMEOUT = 4;
    public static final int INCOMPLETE_ERROR = 5;
    private ExecutionPlanBean mExecutionPlan = new ExecutionPlanBean();
    private TaskBean mTask = new TaskBean();
    private UserBean mUser = new UserBean();
    private HostBean mHost = new HostBean();
    private boolean mIsRunning = false;
    private boolean mIsAborted = false;
    private LinkedList mErrors = new LinkedList();
    private LinkedList mWarnings = new LinkedList();
    private int mInternalStatus = 0;

    public TaskStatus getTaskStatus() {
        if (null == this.mTask.getTaskInfo()) {
            return null;
        }
        return this.mTask.getTaskInfo().getTaskStatus();
    }

    public void addInternalStatus(int inInternalStatus) {
        if (this.mInternalStatus < inInternalStatus) {
            this.mInternalStatus = inInternalStatus;
        }
    }

    public int getInternalStatus() {
        return this.mInternalStatus;
    }

    public int getStatus() {
        switch (this.getInternalStatus()) {
            case 0: {
                if (this.getIsAborted()) {
                    return 3;
                }
                if (!this.getErrors().isEmpty()) {
                    return 5;
                }
                if (!this.getWarnings().isEmpty()) {
                    return 2;
                }
                return 1;
            }
            case 1: {
                if (this.getWarnings().isEmpty()) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                if (this.getIsAborted()) {
                    return 3;
                }
                return 5;
            }
            case 3: {
                return 0;
            }
        }
        return 1;
    }

    public Collection getErrors() {
        return this.mErrors;
    }

    public Collection getWarnings() {
        return this.mWarnings;
    }

    public void addError(ROXStepFailedEvent error) {
        this.mErrors.add(error);
    }

    public void addWarning(ROXStepFailedEvent warning) {
        this.mWarnings.add(warning);
    }

    public void addErrors(Collection inErrors) {
        this.mErrors.addAll(inErrors);
    }

    public void addWarnings(Collection warnings) {
        this.mWarnings.addAll(warnings);
    }

    public TaskID getTaskID() {
        return this.mTask.getTaskID();
    }

    public TaskInfo getTaskInfo() {
        return this.mTask.getTaskInfo();
    }

    public boolean getIsPreflight() {
        return this.mTask.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mTask.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mTask.preflightInUse();
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID, Application inApplication) {
        this.mExecutionPlan.setExecutionPlanID(inExecutionPlanID, inApplication);
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID) {
        this.mExecutionPlan.setExecutionPlanID(inExecutionPlanID);
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlan.getExecutionPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mExecutionPlan.getExecutionPlan();
    }

    public UserID getUserID() {
        return this.mUser.getUserID();
    }

    public void setUserID(UserID inUserID) {
        this.mUser.setUserID(inUserID);
    }

    public String getUsername() {
        return this.mUser.getUsername();
    }

    public void setUsername(String inUsername) {
        this.mUser.setUsername(inUsername);
    }

    public HostID getHostID() {
        return this.mHost.getHostID();
    }

    public void setHostID(HostID inHostID) {
        this.mHost.setHostID(inHostID);
    }

    public SummaryHost getSummaryHost() {
        return this.mHost.getSummaryHost();
    }

    public Date getStartDate() {
        if (null == this.mTask.getTaskInfo()) {
            return null;
        }
        return this.mTask.getTaskInfo().getTaskStart();
    }

    public Date getCompleteDate() {
        if (null == this.mTask.getTaskInfo()) {
            return null;
        }
        return this.mTask.getTaskInfo().getTaskComplete();
    }

    public boolean getIsRunning() {
        return this.getStatus() == 0;
    }

    public void setIsAborted(boolean inIsAborted) {
        this.mIsAborted = inIsAborted;
    }

    public boolean getIsAborted() {
        return this.mIsAborted;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(HostHistoryBean.class.getName()).append("(").append(super.toString()).append("\n");
        buf.append("\tPlan: ").append(this.getExecutionPlanID() == null ? "null" : this.getExecutionPlanID().toString()).append("\n");
        buf.append("\tTask: ").append(this.getTaskID() == null ? "null" : this.getTaskID().toString()).append("\n");
        buf.append("\tUser: ").append(this.getUserID() == null ? "null" : this.getUserID().toString()).append("\n");
        buf.append("\tHost: ").append(this.getHostID() == null ? "null" : this.getHostID().toString()).append("\n");
        buf.append("\tStartDate: ").append(this.getStartDate() == null ? "null" : this.getStartDate().toString()).append("\n");
        buf.append("\tCompleteDate: ").append(this.getCompleteDate() == null ? "null" : this.getCompleteDate().toString()).append("\n");
        buf.append("\tIsRunning: ").append(this.getIsRunning()).append("\n");
        buf.append("\tIsAborted: ").append(this.getIsAborted()).append("\n");
        buf.append("\tStatus: ").append(this.getInternalStatus()).append("\n");
        buf.append("\tErrors: ").append(this.getErrors().size()).append("\n");
        buf.append("\tWarnings: ").append(this.getWarnings().size()).append("\n");
        return buf.toString();
    }

    public static class HostHistoryBeanResultSetProcessor
    extends ResultSetProcessor {
        Vector mResults = new Vector();
        ROXEventFactoryTable mEventTable;
        TargetStatusTable mTargetStatusTable;
        TaskInfoTable mTaskInfoTable;
        HostID mHostID;
        HashMap mBeanMap = new HashMap();

        public HostHistoryBeanResultSetProcessor(ROXEventFactoryTable inEventFactoryTable, TargetStatusTable inTargetStatusTable, TaskInfoTable inTaskInfoTable, HostID inHostID) {
            this.mEventTable = inEventFactoryTable;
            this.mTargetStatusTable = inTargetStatusTable;
            this.mTaskInfoTable = inTaskInfoTable;
            this.mHostID = inHostID;
        }

        public void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
            while (inResultSet.next()) {
                ROXEventFactory theEventFactory = this.mEventTable.retrieveObject(inResultSet);
                TargetStatus theTargetStatus = this.mTargetStatusTable.retrieveObject(inResultSet);
                TaskInfo theTaskInfo = this.mTaskInfoTable.retrieveObject(inResultSet);
                HostHistoryBean theBean = (HostHistoryBean)this.mBeanMap.get(theTaskInfo.getID());
                if (theBean == null) {
                    theBean = new HostHistoryBean();
                    this.mBeanMap.put(theTaskInfo.getID(), theBean);
                    this.mResults.add(theBean);
                    theBean.setExecutionPlanID(new ExecutionPlanID(theEventFactory.getPlanID()));
                    theBean.mTask = new TaskBean(theTaskInfo);
                    theBean.setUserID(theTaskInfo.getRoxUser());
                    theBean.setHostID(this.mHostID);
                    theBean.setIsPreflight(theEventFactory.getIsPreflight());
                    int abortEvents = IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount());
                    theBean.setIsAborted(abortEvents > 0);
                }
                theBean.addInternalStatus(theTargetStatus.getStatus());
                Vector errors = new Vector();
                Vector warnings = new Vector();
                TaskStatusBean.getErrorsAndWarnings(theTaskInfo.getID(), null, null, warnings, errors);
                theBean.addErrors(errors);
                theBean.addWarnings(warnings);
            }
        }

        public boolean loadAssociations() {
            return false;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }
}

