/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;

public class ExecutionPlanBean
extends ParentBean
implements ExecutionPlanInterface {
    private ExecutionPlanID mExecutionPlanID;
    private SummaryExecutionPlan mExecutionPlan;

    public ExecutionPlanBean() {
    }

    public ExecutionPlanBean(SummaryExecutionPlan inPlan) {
        this.mExecutionPlan = inPlan;
        this.mExecutionPlanID = inPlan.getID();
        this.setIsValid(true);
    }

    public ExecutionPlanBean(Application inApplication) {
        super(inApplication);
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID, Application inApplication) {
        if (null == inExecutionPlanID) {
            throw new NullPointerException();
        }
        if (this.mExecutionPlanID == null || !inExecutionPlanID.equals(this.mExecutionPlanID)) {
            this.mExecutionPlanID = inExecutionPlanID;
            this.lookupExecutionPlan(inApplication);
        }
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID) {
        this.setExecutionPlanID(inExecutionPlanID, null);
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlanID;
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mExecutionPlan;
    }

    private void lookupExecutionPlan(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mExecutionPlan = this.mExecutionPlanID.getByIDQuery().selectSummaryView();
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mExecutionPlan = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupExecutionPlan(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

