/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.net.rpc.CommandException;

public class ExceptionBean
extends ParentBean
implements ExceptionInterface {
    String mExceptionDescription;
    CommandException mException;
    boolean mHandled;

    protected void init() {
        super.init();
        this.mExceptionDescription = "";
        this.mException = null;
        this.mHandled = false;
    }

    public void setHandled(boolean inHandled) {
        this.mHandled = inHandled;
    }

    public boolean getHandled() {
        return this.mHandled;
    }

    public void setException(CommandException inException) {
        if (null == inException) {
            throw new NullPointerException();
        }
        this.mException = inException;
        this.doLookup();
    }

    public void setExceptionDescription(String inDescription) {
        this.mExceptionDescription = inDescription;
    }

    private void lookupException() {
        if (null != this.mException) {
            this.mExceptionDescription = this.mException.getMessage();
        }
    }

    public String getExceptionDescription() {
        if (this.mExceptionDescription != null && this.mExceptionDescription.length() > 1024) {
            return this.mExceptionDescription.substring(0, 1024);
        }
        return this.mExceptionDescription;
    }

    public CommandException getException() {
        return this.mException;
    }

    public void doLookup() {
        try {
            if (!this.lookupDone() && Application.getApp().getNotificationManager().performLookup()) {
                this.lookupException();
                this.setLookupDone(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

