/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;

public class DifferenceJobBean
extends ParentBean
implements DifferenceJobInterface {
    private DifferenceJobID mDifferenceJobID;
    private DifferenceSettingsID mDifferenceSettingsID;
    private DifferenceSettings mDifferenceSettings;

    public DifferenceJobBean() {
    }

    public DifferenceJobBean(DifferenceJobID inJobID, DifferenceSettings inDiffSettings) {
        this.mDifferenceJobID = inJobID;
        this.mDifferenceSettingsID = (DifferenceSettingsID)inDiffSettings.getObjectID();
        this.mDifferenceSettings = inDiffSettings;
    }

    public DifferenceJobBean(Application inApplication) {
        super(inApplication);
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID) {
        this.setDifferenceJobID(inDifferenceJobID, null);
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID, Application inApplication) {
        if (null == inDifferenceJobID) {
            throw new NullPointerException();
        }
        if (null == this.mDifferenceJobID || !inDifferenceJobID.equals(this.mDifferenceJobID)) {
            this.mDifferenceJobID = inDifferenceJobID;
            this.lookupDifferenceJob(inApplication);
        }
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID) {
        this.setDifferenceSettingsID(inDifferenceSettingsID, null);
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID, Application inApplication) {
        if (null == inDifferenceSettingsID) {
            throw new NullPointerException();
        }
        if (null == this.mDifferenceSettingsID || !inDifferenceSettingsID.equals(this.mDifferenceSettingsID)) {
            this.mDifferenceSettingsID = inDifferenceSettingsID;
            this.lookupDifferenceSettings(inApplication);
        }
    }

    public DifferenceJobID getDifferenceJobID() {
        return this.mDifferenceJobID;
    }

    public DifferenceSettingsID getDifferenceSettingsID() {
        return this.mDifferenceSettingsID;
    }

    public DifferenceSettings getDifferenceSettings() {
        return this.mDifferenceSettings;
    }

    private void lookupDifferenceJob(Application inApplication) {
    }

    private void lookupDifferenceSettings(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mDifferenceSettings = this.getApp().getDiffDBSubsystem().getDifferenceSettings(this.mDifferenceSettingsID);
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mDifferenceSettings = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupDifferenceJob(null);
                this.lookupDifferenceSettings(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

