/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.query.bean.DifferenceInterface;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobBean;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;

public class DifferenceBean
extends ParentBean
implements DifferenceJobInterface,
DifferenceInterface {
    private DifferenceJobBean mDifferenceJob = new DifferenceJobBean();
    private DifferenceID mDifferenceID;
    private Difference mDifference;
    private String mDifferencePath;
    private int mDifferenceType = -1;

    public DifferenceBean() {
    }

    public DifferenceBean(DifferenceJobBean inDiffJobBean, Difference inDifference) {
        this.mDifferenceJob = inDiffJobBean;
        this.mDifference = inDifference;
        this.mDifferenceID = (DifferenceID)inDifference.getObjectID();
        this.setIsValid(true);
    }

    public DifferenceBean(Application inApplication) {
        super(inApplication);
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID) {
        this.setDifferenceJobID(inDifferenceJobID, null);
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID, Application inApplication) {
        this.mDifferenceJob.setDifferenceJobID(inDifferenceJobID, inApplication);
        this.setIsValid(this.mDifferenceJob.isValid());
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID) {
        this.setDifferenceSettingsID(inDifferenceSettingsID, null);
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID, Application inApplication) {
        this.mDifferenceJob.setDifferenceSettingsID(inDifferenceSettingsID, inApplication);
        this.setIsValid(this.mDifferenceJob.isValid());
    }

    public DifferenceJobID getDifferenceJobID() {
        return this.mDifferenceJob.getDifferenceJobID();
    }

    public DifferenceSettingsID getDifferenceSettingsID() {
        return this.mDifferenceJob.getDifferenceSettingsID();
    }

    public DifferenceSettings getDifferenceSettings() {
        return this.mDifferenceJob.getDifferenceSettings();
    }

    public DifferenceID getDifferenceID() {
        return this.mDifferenceID;
    }

    public Difference getDifference() {
        return this.mDifference;
    }

    public void setDifferenceID(DifferenceID inDifferenceID) {
        this.setDifferenceID(inDifferenceID, null);
    }

    public void setDifferenceID(DifferenceID inDifferenceID, Application inApplication) {
        if (null == inDifferenceID) {
            throw new NullPointerException();
        }
        if (null == this.mDifferenceID || !inDifferenceID.equals(this.mDifferenceID)) {
            this.mDifferenceID = inDifferenceID;
            this.lookupDifference(inApplication);
        }
    }

    public String getDifferencePath() {
        return this.mDifferencePath;
    }

    public void setDifferencePath(String inPath) {
        this.mDifferencePath = inPath;
    }

    public int getDifferenceType() {
        return this.mDifferenceType;
    }

    public void setDifferenceType(int inDifferenceType) {
        this.mDifferenceType = inDifferenceType;
    }

    private void lookupDifference(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mDifference = this.getApp().getDiffDBSubsystem().getDifference(this.getDifferenceID());
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mDifference = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupDifference(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

