/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query.bean;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.query.bean.ComponentInterface;
import com.raplix.rolloutexpress.event.query.bean.ParentBean;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;

public class ComponentBean
extends ParentBean
implements ComponentInterface {
    private ComponentID mComponentID;
    private SummaryComponent mComponent;

    public ComponentBean() {
    }

    public ComponentBean(SummaryComponent inComponent) {
        this.mComponent = inComponent;
        this.mComponentID = inComponent.getID();
        this.setIsValid(true);
    }

    public ComponentBean(Application inApplication) {
        super(inApplication);
    }

    public void setComponentID(ComponentID inComponentID) {
        this.setComponentID(inComponentID, null);
    }

    public void setComponentID(ComponentID inComponentID, Application inApplication) {
        if (null == inComponentID) {
            throw new NullPointerException();
        }
        if (null == this.mComponentID || !inComponentID.equals(this.mComponentID)) {
            this.mComponentID = inComponentID;
            this.lookupComponentID(inApplication);
        }
    }

    public ComponentID getComponentID() {
        return this.mComponentID;
    }

    public SummaryComponent getComponent() {
        return this.mComponent;
    }

    private void lookupComponentID(Application inApplication) {
        try {
            this.setApp(inApplication);
            this.mComponent = this.mComponentID.getByIDQuery().selectSummaryView();
            this.setIsValid(true);
        }
        catch (Exception e) {
            this.logError(e);
            this.setIsValid(false);
            this.mComponent = null;
        }
    }

    public void doLookup() {
        try {
            if (Server.getApp().getNotificationManager().performLookup()) {
                this.lookupComponentID(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

