/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceJobTable;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortEvent;
import com.raplix.rolloutexpress.event.ROXTaskStartEvent;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.bean.HostHistoryBean;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfoTable;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.util.Enumeration;
import java.util.Vector;

public class NotificationQuery
extends ROXEventFactoryTable
implements Messages {
    public static final int SORT_ASCENDING = 2;
    public static final int SORT_DESCENDING = 3;
    NotificationManager mNotificationManager;

    public NotificationQuery(NotificationManager inManager) {
        super("foo");
        this.mNotificationManager = inManager;
    }

    public Vector queryHostHistory(HostID inHostID) throws NotificationManagerException {
        long time = System.currentTimeMillis();
        if (Logger.isDebugEnabled("event.query")) {
            Logger.debug("Beginning HostHistory Query(" + inHostID + ")", "event.query");
        }
        ROXEventFactoryTable outterEventTable = new ROXEventFactoryTable("a");
        TargetStatusTable targetStatusTable = new TargetStatusTable("b");
        TaskInfoTable taskInfoTable = new TaskInfoTable("c");
        ROXEventFactoryTable countEventTable = new ROXEventFactoryTable("e");
        SelectList selectList = NotificationQuery.sList(NotificationQuery.sList((SelectList)outterEventTable.allColumns(), taskInfoTable.allColumns()), targetStatusTable.allColumns(), NotificationQuery.sList(NotificationQuery.scalar(NotificationQuery.select(NotificationQuery.sList(NotificationQuery.count()), NotificationQuery.tList(countEventTable), NotificationQuery.where(NotificationQuery.and(NotificationQuery.equals((ColumnNode)countEventTable.TaskID, taskInfoTable.ID), NotificationQuery.equals(countEventTable.EventType, ROXTaskAbortEvent.class.getName())))))));
        TableList tableList = NotificationQuery.tList(outterEventTable, targetStatusTable, taskInfoTable);
        HostHistoryBean.HostHistoryBeanResultSetProcessor tasksProcessor = new HostHistoryBean.HostHistoryBeanResultSetProcessor(outterEventTable, targetStatusTable, taskInfoTable, inHostID);
        try {
            NotificationQuery.execute(NotificationQuery.select(selectList, tableList, NotificationQuery.where(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.equals((ColumnNode)outterEventTable.TaskID, targetStatusTable.TaskID), NotificationQuery.equals((ColumnNode)outterEventTable.TaskID, taskInfoTable.ID)), NotificationQuery.not(NotificationQuery.isNull(taskInfoTable.TaskStart))), NotificationQuery.equals(outterEventTable.EventType, ROXTaskStartEvent.class.getName())), NotificationQuery.in((ColumnNode)targetStatusTable.TargetID, TargetSQLOps.DEFAULT.selectIDsByHost(inHostID, TargetType.INITIAL)))), NotificationQuery.oList(NotificationQuery.orderByDesc(outterEventTable.Date))), tasksProcessor);
        }
        catch (PersistenceManagerException pme) {
            throw new NotificationManagerException(new ROXMessage(""), (Throwable)pme, 2);
        }
        Vector<HostHistoryBean> running = new Vector<HostHistoryBean>();
        Vector<HostHistoryBean> notRunning = new Vector<HostHistoryBean>();
        Vector stuff = tasksProcessor.getResults();
        Enumeration e = stuff.elements();
        while (e.hasMoreElements()) {
            HostHistoryBean bean = (HostHistoryBean)e.nextElement();
            if (bean.getIsRunning()) {
                running.add(bean);
                continue;
            }
            notRunning.add(bean);
        }
        running.addAll(notRunning);
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString("event.QUERY_DURATION", new Object[]{"HostHistory", new Long(System.currentTimeMillis() - time)}), this);
        }
        return running;
    }

    public Vector queryRunningDiffs(int inMaxResultSetSize) throws NotificationManagerException {
        return this.queryDiff(inMaxResultSetSize, 3, true);
    }

    public Vector queryCompletedDiffs(int inMaxResultSetSize) throws NotificationManagerException {
        return this.queryDiff(inMaxResultSetSize, 2, false);
    }

    protected Vector queryDiff(int inMaxResultSet, int inOrderBy, boolean inRunningOnly) throws NotificationManagerException {
        long time = System.currentTimeMillis();
        DifferenceJobTable diffJobTable = new DifferenceJobTable("dj");
        DifferenceSettingsTable diffSettingsTable = new DifferenceSettingsTable("ds");
        RunningDiffBean.RunningDiffBeanResultSetProcessor resultProcessor = new RunningDiffBean.RunningDiffBeanResultSetProcessor(diffJobTable, diffSettingsTable);
        SelectList slist = NotificationQuery.sList((SelectList)diffJobTable.allColumns(), diffSettingsTable.allColumns());
        TableList tlist = NotificationQuery.tList(diffJobTable, (TableClause)diffSettingsTable);
        WhereClause where = NotificationQuery.where(NotificationQuery.and(NotificationQuery.equals((ColumnNode)diffJobTable.DifferenceSettingsID, diffSettingsTable.ID), inRunningOnly ? NotificationQuery.isNull(diffJobTable.DifferenceComplete) : NotificationQuery.not(NotificationQuery.isNull(diffJobTable.DifferenceComplete))));
        try {
            OrderByList theOrderBy;
            OrderByList orderByList = theOrderBy = inOrderBy == 2 ? NotificationQuery.oList(NotificationQuery.orderByDesc(diffJobTable.DifferenceStart)) : NotificationQuery.oList(NotificationQuery.orderByAsc(diffJobTable.DifferenceStart));
            if (inMaxResultSet == Integer.MAX_VALUE) {
                NotificationQuery.execute(NotificationQuery.select(slist, tlist, where, theOrderBy), resultProcessor);
            } else {
                NotificationQuery.execute(NotificationQuery.limit(NotificationQuery.select(slist, tlist, where, theOrderBy), inMaxResultSet, 0), resultProcessor);
            }
        }
        catch (PersistenceManagerException pmE) {
            throw new NotificationManagerException(new ROXMessage(""), (Throwable)pmE, 2);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString("event.QUERY_DURATION", new Object[]{"DiffQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        return resultProcessor.getResults();
    }

    public Vector queryRunningPlans(String inFullName, int inMaxResultSetSize) throws NotificationManagerException {
        if (Logger.isDebugEnabled("event.query")) {
            Logger.debug("Beginning RunningPlans Query(" + inFullName + "|" + inMaxResultSetSize + ")", "event.query");
        }
        return this.queryPlans(inFullName, inMaxResultSetSize, 3, true);
    }

    public Vector queryCompletedPlans(String inFullName, int inMaxResultSetSize) throws NotificationManagerException {
        if (Logger.isDebugEnabled("event.query")) {
            Logger.debug("Beginning CompletedPlans Query(" + inFullName + "|" + inMaxResultSetSize + ")", "event.query");
        }
        return this.queryPlans(inFullName, inMaxResultSetSize, 2, false);
    }

    protected Vector queryPlans(String inFullName, int inMaxResultSet, int inOrderBy, boolean inRunningOnly) throws NotificationManagerException {
        long time = System.currentTimeMillis();
        ROXEventFactoryTable eventTable = new ROXEventFactoryTable("oe");
        TaskInfoTable taskTable = new TaskInfoTable("ti");
        ExecutionPlanImplTable planTable = new ExecutionPlanImplTable("pt");
        RunningPlanBean.RunningPlanBeanResultSetProcessor resultProcessor = new RunningPlanBean.RunningPlanBeanResultSetProcessor(eventTable, taskTable, planTable);
        try {
            OrderByList theOrderBy;
            WhereClause where = null;
            TableList tlist = NotificationQuery.tList(eventTable, taskTable, planTable);
            if (null != inFullName) {
                String pathName = Util.fullNameToPath(inFullName);
                FolderID thePathID = null;
                try {
                    thePathID = SingleFolderQuery.byPath(pathName).selectSummaryView().getID();
                }
                catch (RPCException e) {
                    throw new NotificationManagerException(new ROXMessage(""), (Throwable)e, 2);
                }
                String planName = Util.fullNameToShortName(inFullName);
                if (Logger.isDebugEnabled("event.query")) {
                    Logger.debug("Searching for plan " + inFullName + " which resolves to " + pathName + " and " + planName, "event.query");
                }
                where = NotificationQuery.where(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.equals(planTable.Name, planName), NotificationQuery.equals(planTable.PathID, thePathID)), NotificationQuery.equals((ColumnNode)taskTable.ID, eventTable.TaskID)), NotificationQuery.equals((ColumnNode)planTable.ID, taskTable.PlanID)), NotificationQuery.not(NotificationQuery.isNull(taskTable.TaskStart))), NotificationQuery.equals(eventTable.EventType, ROXTaskStartEvent.class.getName())), inRunningOnly ? NotificationQuery.isNull(taskTable.TaskComplete) : NotificationQuery.not(NotificationQuery.isNull(taskTable.TaskComplete))));
            } else {
                if (Logger.isDebugEnabled("event.query")) {
                    Logger.debug("No plan specified, getting all plans", "event.query");
                }
                where = NotificationQuery.where(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(NotificationQuery.and(inRunningOnly ? NotificationQuery.isNull(taskTable.TaskComplete) : NotificationQuery.not(NotificationQuery.isNull(taskTable.TaskComplete)), NotificationQuery.equals((ColumnNode)taskTable.ID, eventTable.TaskID)), NotificationQuery.not(NotificationQuery.isNull(taskTable.TaskStart))), NotificationQuery.equals(eventTable.EventType, ROXTaskStartEvent.class.getName())), NotificationQuery.equals((ColumnNode)planTable.ID, taskTable.PlanID)));
            }
            SelectList slist = NotificationQuery.sList(taskTable.allColumns(), eventTable.allColumns(), planTable.allColumns());
            OrderByList orderByList = theOrderBy = inOrderBy == 2 ? NotificationQuery.oList(NotificationQuery.orderByDesc(taskTable.TaskStart)) : NotificationQuery.oList(NotificationQuery.orderByAsc(taskTable.TaskStart));
            if (Logger.isDebugEnabled("event.query")) {
                Logger.debug("Running query with where clause: " + where, "event.query");
            }
            if (inMaxResultSet == Integer.MAX_VALUE) {
                NotificationQuery.execute(NotificationQuery.select(slist, tlist, where, theOrderBy), resultProcessor);
            } else {
                NotificationQuery.execute(NotificationQuery.limit(NotificationQuery.select(slist, tlist, where, theOrderBy), inMaxResultSet, 0), resultProcessor);
            }
        }
        catch (PersistenceManagerException pmE) {
            throw new NotificationManagerException(new ROXMessage(""), (Throwable)pmE, 2);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString("event.QUERY_DURATION", new Object[]{"PlansQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        if (Logger.isDebugEnabled("event.query")) {
            Logger.debug("{Completed|Running}Plans Query returns:\n" + resultProcessor.getResults(), "event.query");
        }
        return resultProcessor.getResults();
    }

    public Vector queryIncompleteStepEvents(TaskID inTaskID) throws NotificationManagerException {
        try {
            ROXEventFactoryTable outerTable = new ROXEventFactoryTable("o");
            StepInfoTable stepTable = new StepInfoTable("si");
            SelectList select = NotificationQuery.sList((SelectList)outerTable.allColumns(), NotificationQuery.sList());
            TableList tables = NotificationQuery.tList(outerTable, (TableClause)stepTable);
            AndExp where = NotificationQuery.and();
            where.add(NotificationQuery.equals(outerTable.EventType, ROXStepStartEvent.class.getName()));
            where.add(NotificationQuery.equals(outerTable.TaskID, inTaskID.toString()));
            where.add(NotificationQuery.equals((ColumnNode)outerTable.StepID, stepTable.ID));
            where.add(NotificationQuery.isNull(stepTable.CompleteDate));
            where.add(NotificationQuery.not(NotificationQuery.equals(stepTable.StepStatusAsString, StepStatus.INCOMPLETE_ABORT.toString())));
            PersistentBean[] events = NotificationQuery.executeMultiResult(NotificationQuery.select(select, tables, NotificationQuery.where(where)), outerTable);
            Vector<ROXEvent> results = new Vector<ROXEvent>(events.length);
            for (int i = 0; i < events.length; ++i) {
                results.add(((ROXEventFactory)events[i]).instantiate());
            }
            return results;
        }
        catch (PersistenceManagerException pme) {
            throw new NotificationManagerException(new ROXMessage(""), (Throwable)pme, 2);
        }
    }

    public Vector queryStepEvents(StepID inStepID, String[] eventTypes) throws NotificationManagerException {
        try {
            ROXEventFactoryTable table = ROXEventFactoryTable.DEFAULT;
            PersistentBean[] events = NotificationQuery.executeMultiResult(NotificationQuery.select(table.allColumns(), NotificationQuery.tList(table), NotificationQuery.where(NotificationQuery.and(NotificationQuery.and(NotificationQuery.equals(table.StepID, inStepID.toString()), NotificationQuery.emptyIn(table.EventType, NotificationQuery.rList(eventTypes))), NotificationQuery.equals(table.IsPreflight, false)))), table);
            Vector<ROXEvent> results = new Vector<ROXEvent>(events.length);
            for (int i = 0; i < events.length; ++i) {
                results.add(((ROXEventFactory)events[i]).instantiate());
            }
            return results;
        }
        catch (PersistenceManagerException pme) {
            throw new NotificationManagerException(new ROXMessage(""), (Throwable)pme, 2);
        }
    }
}

