/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event.query;

import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactorySQLOps;
import com.raplix.rolloutexpress.event.ROXEventID;
import com.raplix.rolloutexpress.event.query.EventOrder;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;

public class MultiEventQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    static final ROXEventFactorySQLOps TABLE = new ROXEventFactorySQLOps("eventT");
    private Class mTypeFilter;

    public static MultiEventQuery all() {
        MultiEventQuery theQuery = new MultiEventQuery((ConditionalExpression)null);
        theQuery.setObjectOrder(EventOrder.BY_DATE_ASC);
        return theQuery;
    }

    public static MultiEventQuery byIDs(ROXEventID[] IDs) {
        return new MultiEventQuery(IDs);
    }

    public static MultiEventQuery byTaskID(TaskID inTaskID) {
        MultiEventQuery result = new MultiEventQuery(ROXEventFactorySQLOps.equals(MultiEventQuery.TABLE.TaskID, inTaskID.toString()));
        result.setObjectOrder(EventOrder.BY_DATE_ASC);
        return result;
    }

    public static MultiEventQuery byInstalledComponentID(InstalledComponentID inInstalledComponentID) {
        MultiEventQuery result = new MultiEventQuery(ROXEventFactorySQLOps.equals(MultiEventQuery.TABLE.InstalledComponentID, inInstalledComponentID.toString()));
        result.setObjectOrder(EventOrder.BY_DATE_ASC);
        return result;
    }

    public static MultiEventQuery byDifferenceJobID(DifferenceJobID inDifferenceJobID) {
        MultiEventQuery result = new MultiEventQuery(ROXEventFactorySQLOps.equals(MultiEventQuery.TABLE.DifferenceJobID, inDifferenceJobID.toString()));
        result.setObjectOrder(EventOrder.BY_DATE_ASC);
        return result;
    }

    public static MultiEventQuery byDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID) {
        MultiEventQuery result = new MultiEventQuery(ROXEventFactorySQLOps.equals(MultiEventQuery.TABLE.DifferenceSettingsID, inDifferenceSettingsID.toString()));
        result.setObjectOrder(EventOrder.BY_DATE_ASC);
        return result;
    }

    public static MultiEventQuery byStepID(StepID inStepID) {
        MultiEventQuery result = new MultiEventQuery(ROXEventFactorySQLOps.equals(MultiEventQuery.TABLE.StepID, inStepID.toString()));
        result.setObjectOrder(EventOrder.BY_DATE_ASC);
        return result;
    }

    protected MultiEventQuery(ConditionalExpression whereClause) {
        super((Table)TABLE, whereClause, EventOrder.FACTORY);
    }

    private MultiEventQuery(ROXEventID[] IDs) {
        super((Table)TABLE, IDs, EventOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder inEventOrder) {
        super.setObjectOrder((EventOrder)inEventOrder);
    }

    public Class getTypeFilter() {
        return this.mTypeFilter;
    }

    public void setTypeFilter(Class inTypeFilter) {
        this.mTypeFilter = inTypeFilter;
    }

    protected ConditionalExpression getFilterCondition(Table table) {
        ROXEventFactorySQLOps t = (ROXEventFactorySQLOps)table;
        ConditionalExpression mainFilter = super.getFilterCondition(t);
        AndExp result = null;
        if (mainFilter != null) {
            result = t.and();
            result.add(mainFilter);
        }
        if (this.getTypeFilter() != null) {
            if (result == null) {
                result = t.and();
            }
            result.add(ROXEventFactorySQLOps.equals(t.EventType, this.getTypeFilter().getName()));
        }
        return result;
    }

    public ROXEvent[] select() throws RPCException, PersistenceManagerException {
        ROXEventFactory[] results = (ROXEventFactory[])this.selectBeans(ROXEventFactory.class);
        ROXEvent[] actualResults = new ROXEvent[results.length];
        for (int i = 0; i < results.length; ++i) {
            actualResults[i] = results[i].instantiate();
        }
        return actualResults;
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }
}

