/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.TargetStatusID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.ObjectUtil;
import com.sun.n1.sps.model.executor.TargetStatusCode;

public class TargetStatus
extends PersistentObject
implements RPCSerializable,
HasObjectID {
    public static final int NONE = 0;
    public static final int SUCCESS = 1;
    public static final int FAILURE = 2;
    public static final int INPROGRESS = 3;
    public static final int ABORTED = 4;
    public static final int TIMED_OUT = 5;
    private int mStatus;
    private TargetID mTargetID;
    private TaskID mTaskID;

    private TargetStatus() {
    }

    public TargetStatus(TargetID inTargetID, int inStatus, TaskID inTaskID) {
        this.mStatus = inStatus;
        this.setTargetID(inTargetID);
        this.setTaskID(inTaskID);
    }

    public TargetStatus(Target inTarget, int inStatus, TaskID inTaskID) {
        this.mStatus = inStatus;
        this.setTargetID(inTarget.getID());
        this.setTaskID(inTaskID);
    }

    public boolean failed() {
        return this.mStatus == 2 || this.mStatus == 4 || this.mStatus == 5;
    }

    public boolean running() {
        return this.mStatus == 3 || this.mStatus == 0;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public TargetID getTargetID() {
        return this.mTargetID;
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public void setStatus(int inStatus) {
        this.mStatus = inStatus;
    }

    public TargetStatusCode getTargetStatusCode() {
        return TargetStatusCode.FACTORY.get(this.mStatus);
    }

    public void setTargetID(TargetID inTargetID) {
        this.mTargetID = inTargetID;
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTaskID = inTaskID;
    }

    public Target getTarget() throws RPCException, PersistenceManagerException {
        return this.getTargetID().getByIDQuery().select();
    }

    public HostID getHostID() {
        try {
            return this.mTargetID.getByIDQuery().selectSummaryView().getInitialHostID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object inObject) {
        if (inObject == this) {
            return true;
        }
        if (inObject != null && inObject instanceof TargetStatus) {
            TargetStatus inStatus = (TargetStatus)inObject;
            return ObjectUtil.equals(this.mTargetID, inStatus.getTargetID()) && ObjectUtil.equals(this.mTaskID, inStatus.getTaskID()) && this.mStatus == inStatus.getStatus();
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(").append(this.getID() != null ? this.getID().toString() : "null").append(") ");
        buf.append("Task[").append(this.mTaskID != null ? this.mTaskID.toString() : "null");
        buf.append(", Target[").append(this.mTargetID != null ? this.mTargetID.toString() : "null");
        buf.append("], Status[").append(this.getStringStatus(this.mStatus)).append(" ]");
        return buf.toString();
    }

    public TargetStatusID getID() {
        return (TargetStatusID)this.getObjectID();
    }

    private String getStringStatus(int inStatus) {
        String result = null;
        switch (inStatus) {
            case 2: {
                result = "FAILURE";
                break;
            }
            case 1: {
                result = "SUCCESS";
                break;
            }
            case 3: {
                result = "INPROGRESS";
            }
        }
        return result;
    }
}

