/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXUserEvent;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public class ROXUserLoginFailedEvent
extends ROXUserEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages {
    private ExceptionBean mException = new ExceptionBean();

    public ROXUserLoginFailedEvent(Date inDate, String inMessage, UserID inUserID) {
        super(inDate, inMessage, inUserID);
    }

    public ROXUserLoginFailedEvent(Date inDate, String inMessage, UserID inUserID, CommandException inException) {
        super(inDate, inMessage, inUserID);
        this.setException(inException);
    }

    public ROXUserLoginFailedEvent(Date inDate, String inMessage, String inUsername) {
        super(inDate, inMessage, inUsername);
    }

    public ROXUserLoginFailedEvent(Date inDate, String inMessage, String inUsername, CommandException inException) {
        super(inDate, inMessage, inUsername);
        this.setException(inException);
    }

    public ROXUserLoginFailedEvent() {
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public void setExceptionDescription(String inDescription) {
        this.mException.setExceptionDescription(inDescription);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        ref.setException(this.getException());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.USERLOGINFAILED_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }

    public String formatMessage() {
        String userName = ROXMessageManager.messageAsString("event.UNKNOWN_USER");
        if (null != this.getUsername()) {
            userName = this.getUsername();
        } else if (null != this.getUserID()) {
            userName = this.getUserID().toString() + "*";
        }
        CommandException e = this.getException();
        return ROXMessageManager.messageAsString("event.USERLOGINFAILED_MESSAGE", new Object[]{userName, new Double(null == e ? 0.0 : 1.0), null == e ? null : ((Throwable)e).getMessage(), this.getDate()});
    }
}

