/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXUserLoginEvent;
import com.raplix.rolloutexpress.event.ROXUserLoginFailedEvent;
import com.raplix.rolloutexpress.event.ROXUserLogoutEvent;
import com.raplix.rolloutexpress.event.query.bean.HostBean;
import com.raplix.rolloutexpress.event.query.bean.HostInterface;
import com.raplix.rolloutexpress.event.query.bean.UserBean;
import com.raplix.rolloutexpress.event.query.bean.UserInterface;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.util.Date;

public abstract class ROXUserEvent
extends ROXEvent
implements UserInterface,
HostInterface {
    private UserBean mUser = new UserBean();
    private HostBean mHost = new HostBean();

    protected ROXUserEvent() {
    }

    public ROXUserEvent(Date inDate, String inMessage, UserID inUserID) {
        super(inDate, inMessage);
        this.setUserID(inUserID);
    }

    public ROXUserEvent(Date inDate, String inMessage, String inUsername) {
        super(inDate, inMessage);
        this.setUsername(inUsername);
    }

    public UserID getUserID() {
        return this.mUser.getUserID();
    }

    public void setUserID(UserID inUserID) {
        this.mUser.setUserID(inUserID);
    }

    public String getUsername() {
        return this.mUser.getUsername();
    }

    public void setUsername(String inUsername) {
        this.mUser.setUsername(inUsername);
    }

    public HostID getHostID() {
        return this.mHost.getHostID();
    }

    public void setHostID(HostID inHostID) {
        this.mHost.setHostID(inHostID);
    }

    public SummaryHost getSummaryHost() {
        return this.mHost.getSummaryHost();
    }

    public static ROXUserLoginEvent login(UserID inUserID) {
        return new ROXUserLoginEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUserID);
    }

    public static ROXUserLoginFailedEvent loginFailed(UserID inUserID, CommandException inException) {
        return new ROXUserLoginFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUserID, inException);
    }

    public static ROXUserLoginFailedEvent loginFailed(UserID inUserID) {
        return new ROXUserLoginFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUserID);
    }

    public static ROXUserLoginFailedEvent loginFailed(String inUsername, CommandException inException) {
        return new ROXUserLoginFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUsername, inException);
    }

    public static ROXUserLoginFailedEvent loginFailed(String inUsername) {
        return new ROXUserLoginFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUsername);
    }

    public static ROXUserLogoutEvent logout(UserID inUserID) {
        return new ROXUserLogoutEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inUserID);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mUser = new UserBean();
        String id = inFactory.getUserID();
        if (null != id) {
            this.setUserID(new UserID(id));
        }
        this.setUsername(inFactory.getUsername());
        this.mHost = new HostBean();
        id = inFactory.getHostID();
        if (null != id) {
            this.mHost.setHostID(new HostID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setUserID(this.getUserID());
        ref.setUsername(this.getUsername());
        ref.setHostID(this.mHost.getHostID());
        return ref;
    }

    protected String getClassSubsystemName() {
        return UserDBSubsystem.getClassSubsystemName();
    }

    protected void doLookup() {
        this.mUser.doLookup();
    }

    public void welcomeToTheServer(NotificationManager inNotificationManager) {
        block3: {
            super.welcomeToTheServer(inNotificationManager);
            Server server = (Server)Server.getApp();
            if (server != null) {
                try {
                    HostDBSubsystem hostDB = server.getHostDBSubsystem();
                    String msIP = hostDB.getConfigMSIP();
                    int msPort = hostDB.getConfigMSPort();
                    RoxAddress msAddress = new RoxAddress(msIP, msPort);
                    SingleAppInstanceQuery saip = SingleAppInstanceQuery.byAddress(msAddress, AppType.MS);
                    AppInstance msApp = saip.select();
                    this.mHost.setHostID(msApp.getHostID());
                }
                catch (Exception e) {
                    if (!Logger.isDebugEnabled(this)) break block3;
                    Logger.debug("Caught an exception while trying to find the MS hostID while user logging in/out", e, this);
                }
            }
        }
    }
}

