/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.AffectedTarget;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.query.bean.UserBean;
import com.raplix.rolloutexpress.event.query.bean.UserInterface;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public class ROXTaskStartEvent
extends ROXTaskEvent
implements ROXEventFactoryInterface,
UserInterface,
Messages,
AffectedTarget {
    private UserBean mUser = new UserBean();

    public ROXTaskStartEvent(Date inDate, String inMessage, TaskID inTaskID, ExecutionPlanID inPlanID, UserID inUserID, boolean isPreflight) {
        super(inDate, inMessage, 2, inTaskID, inPlanID, isPreflight);
        this.setUserID(inUserID);
    }

    public ROXTaskStartEvent() {
        this.setSeverity(2);
    }

    public UserID getUserID() {
        return this.mUser.getUserID();
    }

    public void setUserID(UserID inUserID) {
        this.mUser.setUserID(inUserID);
    }

    public String getUsername() {
        return this.mUser.getUsername();
    }

    public void setUsername(String inUsername) {
        this.mUser.setUsername(inUsername);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setUserID(this.getUserID());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mUser = new UserBean();
        String id = inFactory.getUserID();
        if (null != id) {
            this.setUserID(new UserID(id));
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.TASKSTART_DESCRIPTION");
    }

    protected void doLookup() {
        this.mUser.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        String userName = "*";
        if (null != this.getUserID()) {
            userName = this.getUserID().toString() + "*";
        }
        if (null != this.getUsername()) {
            userName = this.getUsername();
        }
        return ROXMessageManager.messageAsString("event.TASKSTART_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), this.getDate(), userName});
    }

    public TargetStatus[] getAllAffectedTargets() throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return new TargetStatus[0];
        }
        return task.getAllTargetsStatus();
    }

    public TargetStatus getTargetStatus(TargetID inID) throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return null;
        }
        return task.getTargetStatus(inID);
    }
}

