/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.query.bean.ProgressBean;
import com.raplix.rolloutexpress.event.query.bean.ProgressInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class ROXTaskProgressEvent
extends ROXTaskEvent
implements ROXEventFactoryInterface,
ProgressInterface,
Messages {
    private ProgressBean mProgress = new ProgressBean();

    public ROXTaskProgressEvent() {
        this.setSeverity(1);
    }

    public ROXTaskProgressEvent(Date inDate, String inMessage, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight, double inProgress) {
        super(inDate, inMessage, 1, inTaskID, inPlanID, isPreflight);
        this.setProgress(inProgress);
    }

    public double getProgress() {
        return this.mProgress.getProgress();
    }

    public void setProgress(double inProgress) {
        this.mProgress.setProgress(inProgress);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setPercentDone(this.getProgress());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.setProgress(inFactory.getPercentDone());
    }

    protected boolean beforeSave(NotificationManager inNM) {
        ROXEvent[] input = new ROXEvent[1];
        try {
            input[0] = this.getKeyObject(false);
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_KEY_CREATION_ERROR"), e, this);
            }
            return false;
        }
        try {
            ROXEvent[] output = inNM.query(input);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has a precursor(" + output[0] + ") - proceed with update", this);
            }
            this.setEventID(output[0].getEventID());
            this.shouldInsert = false;
        }
        catch (EmptyQueryException eqe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has no precursor - continue with add", this);
            }
            this.shouldInsert = true;
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_EVENT_RETRIEVAL_ERROR"), e, this);
            }
            return false;
        }
        return true;
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.TASKPROGRESS_DESCRIPTION");
    }

    protected void doLookup() {
        this.mProgress.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        return ROXMessageManager.messageAsString("event.TASKPROGRESS_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), new Double(this.getProgress()), this.getDate()});
    }
}

