/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.AffectedTarget;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import java.util.Date;

public class ROXTaskFailedEvent
extends ROXTaskEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages,
AffectedTarget {
    ExceptionBean mException = new ExceptionBean();

    public ROXTaskFailedEvent() {
        this.setSeverity(4);
    }

    public ROXTaskFailedEvent(Date inDate, String inMessage, int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight, CommandException inEx) {
        super(inDate, inMessage, inSeverity, inTaskID, inPlanID, isPreflight);
        this.setException(inEx);
    }

    public ROXTaskFailedEvent(Date inDate, String inMessage, int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        super(inDate, inMessage, inSeverity, inTaskID, inPlanID, isPreflight);
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public void setExceptionDescription(String inDescription) {
        this.mException.setExceptionDescription(inDescription);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        ref.setException(this.getException());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.TASKFAILED_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        CommandException e = this.getException();
        return ROXMessageManager.messageAsString("event.TASKFAILED_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), new Double(null == e ? 0.0 : 1.0), null == e ? null : ((Throwable)e).getMessage(), this.getDate()});
    }

    public TargetStatus[] getAllAffectedTargets() throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return new TargetStatus[0];
        }
        return task.getAllTargetsStatus();
    }

    public TargetStatus getTargetStatus(TargetID inID) throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return null;
        }
        return task.getTargetStatus(inID);
    }
}

