/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXPreflightCompleteEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXTaskCompleteEvent;
import com.raplix.rolloutexpress.event.ROXTaskFailedEvent;
import com.raplix.rolloutexpress.event.ROXTaskProgressEvent;
import com.raplix.rolloutexpress.event.ROXTaskStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskTimeoutEvent;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanInterface;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public abstract class ROXTaskEvent
extends ROXEvent
implements TaskInterface,
ExecutionPlanInterface {
    private TaskBean mTask = new TaskBean();
    private ExecutionPlanBean mExecutionPlan = new ExecutionPlanBean();

    public ROXTaskEvent(Date inDate, String inMessage, int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        super(inDate, inMessage, inSeverity);
        this.setTaskID(inTaskID);
        this.setIsPreflight(isPreflight);
        this.setExecutionPlanID(inPlanID);
    }

    protected ROXTaskEvent(Date inDate, String inMessage, int inSeverity, TaskID inTaskID) {
        super(inDate, inMessage, inSeverity);
        this.setTaskID(inTaskID);
    }

    protected ROXTaskEvent() {
    }

    public TaskID getTaskID() {
        return this.mTask.getTaskID();
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTask.setTaskID(inTaskID);
    }

    public TaskInfo getTaskInfo() {
        return this.mTask.getTaskInfo();
    }

    public boolean getIsPreflight() {
        return this.mTask.getIsPreflight();
    }

    public boolean preflightInUse() {
        return this.mTask.preflightInUse();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mTask.setIsPreflight(isPreflight);
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlan.getExecutionPlanID();
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID) {
        this.mExecutionPlan.setExecutionPlanID(inExecutionPlanID);
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mExecutionPlan.getExecutionPlan();
    }

    public static ROXTaskStartEvent start(TaskID inTaskID, ExecutionPlanID inPlanID, UserID inUserID, boolean isPreflight) {
        return new ROXTaskStartEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, inUserID, isPreflight);
    }

    public static ROXTaskAbortEvent abort(TaskID inTaskID, ExecutionPlanID inPlanID, TargetID inTargetID, boolean isPreflight) {
        return new ROXTaskAbortEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, inTargetID, isPreflight);
    }

    public static ROXTaskTimeoutEvent timeout(TaskID inTaskID, ExecutionPlanID inPlanID, TargetID inTargetID, boolean isPreflight) {
        return new ROXTaskTimeoutEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, inTargetID, isPreflight);
    }

    public static ROXTaskTimeoutEvent timeout(TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        return new ROXTaskTimeoutEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, isPreflight);
    }

    public static ROXTaskAbortRequestedEvent abortRequested(TaskID inTaskID) {
        return new ROXTaskAbortRequestedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID);
    }

    public static ROXTaskAbortEvent abort(TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        return new ROXTaskAbortEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, isPreflight);
    }

    public static ROXTaskCompleteEvent complete(TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        return new ROXTaskCompleteEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, isPreflight);
    }

    public static ROXPreflightCompleteEvent preflightComplete(int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID) {
        return new ROXPreflightCompleteEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inTaskID, inPlanID);
    }

    public static ROXTaskFailedEvent failed(int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight, CommandException inException) {
        return new ROXTaskFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inTaskID, inPlanID, isPreflight, inException);
    }

    public static ROXTaskFailedEvent failed(int inSeverity, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        return new ROXTaskFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inTaskID, inPlanID, isPreflight);
    }

    public static ROXTaskProgressEvent progress(TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight, double inProgress) {
        return new ROXTaskProgressEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inTaskID, inPlanID, isPreflight, inProgress);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mTask = new TaskBean();
        String id = inFactory.getTaskID();
        this.setIsPreflight(inFactory.getIsPreflight());
        if (null != id) {
            this.setTaskID(new TaskID(id));
        }
        this.mExecutionPlan = new ExecutionPlanBean();
        id = inFactory.getPlanID();
        if (null != id) {
            this.setExecutionPlanID(new ExecutionPlanID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setTaskID(this.getTaskID());
        if (this.preflightInUse()) {
            ref.setIsPreflight(this.getIsPreflight());
        }
        ref.setPlanID(this.getExecutionPlanID());
        return ref;
    }

    protected void doLookup() {
        this.mTask.doLookup();
        this.mExecutionPlan.doLookup();
    }
}

