/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.AffectedTarget;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.ROXTaskProgressEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import java.util.Date;

public class ROXTaskCompleteEvent
extends ROXTaskEvent
implements ROXEventFactoryInterface,
Messages,
AffectedTarget {
    public ROXTaskCompleteEvent() {
        this.setSeverity(2);
    }

    public ROXTaskCompleteEvent(Date inDate, String inMessage, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        super(inDate, inMessage, 2, inTaskID, inPlanID, isPreflight);
    }

    protected void afterSave(NotificationManager inNM) {
        ROXEvent[] input = new ROXEvent[1];
        ROXTaskProgressEvent prog = new ROXTaskProgressEvent();
        try {
            this.formatKey(prog, false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.TASKCOMPLETE_DESCRIPTION");
    }

    public String formatMessage() {
        String planName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        return ROXMessageManager.messageAsString("event.TASKCOMPLETE_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), this.getDate()});
    }

    public TargetStatus[] getAllAffectedTargets() throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return new TargetStatus[0];
        }
        return task.getAllTargetsStatus();
    }

    public TargetStatus getTargetStatus(TargetID inID) throws PlanExecutionException {
        TaskInfo task = TaskInfo.getTaskFromCache(this.getTaskID());
        if (null == task) {
            return null;
        }
        return task.getTargetStatus(inID);
    }
}

