/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.query.bean.TargetBean;
import com.raplix.rolloutexpress.event.query.bean.TargetInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import java.util.Date;

public class ROXTaskAbortEvent
extends ROXTaskEvent
implements ROXEventFactoryInterface,
TargetInterface,
Messages {
    private TargetBean mTarget = new TargetBean();

    public ROXTaskAbortEvent(Date inDate, String inMessage, TaskID inTaskID, ExecutionPlanID inPlanID, TargetID inTargetID, boolean isPreflight) {
        super(inDate, inMessage, 2, inTaskID, inPlanID, isPreflight);
        this.setTargetID(inTargetID);
    }

    public ROXTaskAbortEvent(Date inDate, String inMessage, TaskID inTaskID, ExecutionPlanID inPlanID, boolean isPreflight) {
        super(inDate, inMessage, 2, inTaskID, inPlanID, isPreflight);
    }

    public ROXTaskAbortEvent() {
        this.setSeverity(2);
    }

    public TargetID getTargetID() {
        return this.mTarget.getTargetID();
    }

    public HostID getHostID() {
        if (this.mTarget == null || this.mTarget.getSummaryTarget() == null) {
            return null;
        }
        return this.mTarget.getSummaryTarget().getInitialHostID();
    }

    public void setTargetID(TargetID inTargetID) {
        this.mTarget.setTargetID(inTargetID);
    }

    public SummaryTarget getSummaryTarget() {
        return this.mTarget.getSummaryTarget();
    }

    public Target getTarget() {
        return this.mTarget.getTarget();
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setTargetID(this.getTargetID());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mTarget = new TargetBean();
        String id = inFactory.getTargetID();
        if (null != id) {
            this.setTargetID(new TargetID(id));
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.TASKABORT_DESCRIPTION");
    }

    protected void doLookup() {
        this.mTarget.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        String targetName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getInitialHost().getName();
        }
        boolean useTarget = null != this.getTargetID();
        return ROXMessageManager.messageAsString("event.TASKABORT_MESSAGE", new Object[]{planName, new Double(useTarget ? 1.0 : 0.0), useTarget ? targetName : null, new Double(this.getIsPreflight() ? 1.0 : 0.0), this.getDate()});
    }
}

