/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXNodeStartEvent;
import com.raplix.rolloutexpress.event.ROXNodeStopEvent;
import java.net.InetAddress;
import java.util.Date;

public abstract class ROXSystemEvent
extends ROXEvent {
    private String mNodeType;
    private String mHostname;
    private String mHostIP;

    public ROXSystemEvent(Date inDate, String inMessage, InetAddress inHostAddress, String inNodeType) {
        super(inDate, inMessage);
        this.setHostAddress(inHostAddress);
        this.setNodeType(inNodeType);
    }

    protected ROXSystemEvent() {
    }

    public String getNodeType() {
        return this.mNodeType;
    }

    public void setNodeType(String inNodeType) {
        this.mNodeType = inNodeType;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public void setHostname(String inHostname) {
        this.mHostname = inHostname;
    }

    public String getHostIP() {
        return this.mHostIP;
    }

    public void setHostIP(String inHostIP) {
        this.mHostIP = inHostIP;
    }

    public void setHostAddress(InetAddress inHostAddress) {
        this.setHostname(inHostAddress.getHostName());
        this.setHostIP(inHostAddress.getHostAddress());
    }

    public static ROXNodeStartEvent nodeStart(InetAddress inHostAddress, String inNodeType) {
        return new ROXNodeStartEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inHostAddress, inNodeType);
    }

    public static ROXNodeStopEvent nodeStop(InetAddress inHostAddress, String inNodeType) {
        return new ROXNodeStopEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inHostAddress, inNodeType);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mHostname = inFactory.getHostname();
        this.mHostIP = inFactory.getHostIP();
        this.mNodeType = inFactory.getNodeType();
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setHostname(this.getHostname());
        ref.setHostIP(this.getHostIP());
        ref.setNodeType(this.getNodeType());
        return ref;
    }

    protected void doLookup() {
    }
}

