/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import java.util.Date;

public class ROXStepStartEvent
extends ROXStepEvent
implements ROXEventFactoryInterface,
Messages {
    public ROXStepStartEvent() {
        this.setSeverity(2);
    }

    public ROXStepStartEvent(Date inDate, String inMessage, StepInfo inStepInfo, int inSubPlanIndex) {
        super(inDate, inMessage, 2, inStepInfo, inStepInfo.getRunLevel().equals(RunLevel.PREFLIGHT), inSubPlanIndex);
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.STEPSTART_DESCRIPTION");
    }

    public String formatMessage() {
        String planName = "*";
        String targetName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getInitialHost().getName();
        }
        return ROXMessageManager.messageAsString("event.STEPSTART_MESSAGE", new Object[]{this.getStepTypeDescription(), planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), targetName, this.getDate()});
    }
}

